/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.outreach.internal.capabilities;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.plugins.outreach.internal.OutreachHelper;
import com.sonatype.nexus.plugins.outreach.internal.capabilities.OutreachManagementCapabilityConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.capability.CapabilitySupport;
import org.sonatype.nexus.capability.Condition;

@Named(value="OutreachManagementCapability")
public class OutreachManagementCapability
extends CapabilitySupport<OutreachManagementCapabilityConfiguration> {
    private final OutreachHelper outreachHelper;

    @Inject
    public OutreachManagementCapability(OutreachHelper outreachHelper) {
        this.outreachHelper = (OutreachHelper)((Object)Preconditions.checkNotNull((Object)((Object)outreachHelper)));
    }

    protected OutreachManagementCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new OutreachManagementCapabilityConfiguration(properties);
    }

    public Condition activationCondition() {
        final File tmpDir = this.outreachHelper.getTemporaryDirectory();
        return new Condition(){

            public boolean isSatisfied() {
                File test = new File(tmpDir, "outreach.test");
                if (!test.exists() || test.delete()) {
                    try {
                        test.createNewFile();
                        test.delete();
                        return true;
                    }
                    catch (IOException iOException) {
                        OutreachManagementCapability.this.log.warn("No write access for temp directory ({})", (Object)tmpDir);
                    }
                } else {
                    OutreachManagementCapability.this.log.warn("No write access for temp directory ({}), could not delete file '{}'", (Object)tmpDir, (Object)test.getName());
                }
                return false;
            }

            public Condition bind() {
                return this;
            }

            public Condition release() {
                return this;
            }

            public String explainSatisfied() {
                return "Outreach temporary Directory is created";
            }

            public String explainUnsatisfied() {
                return "Cannot write to Outreach temp directory (" + tmpDir + ")";
            }
        };
    }
}

