/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository.migrators.orient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.hash.HashCode;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.repository.migrators.NugetMigratorHelper;
import com.sonatype.nexus.migration.repository.migrators.orient.OrientRepositoryMigratorSupport;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import com.sonatype.nexus.repository.nuget.orient.OrientNugetComponentHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="nuget-hosted")
public class OrientNugetHostedRepositoryMigrator
extends OrientRepositoryMigratorSupport {
    private static final String MIGRATION_ATTRIBUTES_KEY = "migration";
    private static final String PATH = "path";
    private static final String NUGET = "nuget";

    @Override
    @Nullable
    protected Asset recordMetadata(StorageTx tx, RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        NugetPackageCoords coords = this.nugetCoords(change);
        return this.getOrCreateAsset(tx, coords, change);
    }

    public Asset getOrCreateAsset(StorageTx tx, NugetPackageCoords coords, RepositoryChangelogClient.ChangeEntryXO change) {
        Component component = this.findOrCreateComponent(tx, coords.getId(), coords.getVersion());
        this.recordPath(change, component);
        tx.saveComponent(component);
        Asset asset = this.findOrCreateAsset(tx, component);
        NestedAttributesMap nugetAttr = asset.formatAttributes();
        NestedAttributesMap data = change.getChange().getAsset().attributes().child(NUGET);
        nugetAttr.set("authors", data.get("AUTHORS"));
        nugetAttr.set("copyright", data.get("COPYRIGHT"));
        nugetAttr.set("dependencies", data.get("DEPENDENCIES"));
        nugetAttr.set("description", data.get("DESCRIPTION"));
        nugetAttr.set("gallery_details_url", data.get("GALLERYDETAILSURL"));
        nugetAttr.set("icon_url", data.get("ICONURL"));
        nugetAttr.set("id", data.get("ID"));
        nugetAttr.set("is_prerelease", data.get("ISPRERELEASE", Boolean.class));
        nugetAttr.set("language", data.get("LANGUAGE"));
        nugetAttr.set("license_url", data.get("LICENSEURL"));
        nugetAttr.set("location", data.get("LOCATION"));
        nugetAttr.set("package_hash", data.get("PACKAGEHASH"));
        nugetAttr.set("package_hash_algorithm", data.get("PACKAGEHASHALGORITHM"));
        Number pkgSizeNum = (Number)data.get("PACKAGESIZE", Number.class);
        nugetAttr.set("package_size", pkgSizeNum == null ? null : Long.valueOf(pkgSizeNum.longValue()));
        nugetAttr.set("project_url", data.get("PROJECTURL"));
        nugetAttr.set("release_notes", data.get("RELEASENOTES"));
        nugetAttr.set("report_abuse_url", data.get("REPORTABUSEURL"));
        nugetAttr.set("require_license_acceptance", data.get("REQUIRELICENSEACCEPTANCE", Boolean.class));
        nugetAttr.set("summary", data.get("SUMMARY"));
        nugetAttr.set("tags", data.get("TAGS"));
        nugetAttr.set("title", data.get("TITLE"));
        nugetAttr.set("version", data.get("VERSION"));
        nugetAttr.set("download_count", data.get("DOWNLOADCOUNT", Integer.class));
        nugetAttr.set("version_download_count", data.get("VERSIONDOWNLOADCOUNT", Integer.class));
        nugetAttr.set("created", (Object)this.asDate((Long)data.get("CREATED", Long.class), new Date()));
        nugetAttr.set("published", (Object)this.asDate((Long)data.get("PUBLISHED", Long.class), new Date()));
        nugetAttr.set("last_updated", (Object)this.asDate((Long)data.get("last_updated", Long.class), new Date()));
        TempBlob tempBlob = this.getTempBlob(change);
        if (tempBlob != null) {
            Map<String, String> metadata = NugetMigratorHelper.getMetadata(tempBlob, change);
            String dependencies = metadata.get("DEPENDENCIES");
            nugetAttr.set("dependencies", (Object)dependencies);
        }
        OrientNugetComponentHelper.updateDerivedTextFields((Asset)asset);
        return asset;
    }

    @VisibleForTesting
    void recordPath(RepositoryChangelogClient.ChangeEntryXO change, Component component) {
        NestedAttributesMap migration = component.attributes().child(MIGRATION_ATTRIBUTES_KEY);
        migration.set(PATH, (Object)this.getItemPath(change));
    }

    private Date asDate(Long timestamp, Date defaultValue) {
        if (timestamp == null) {
            return defaultValue;
        }
        return new Date(timestamp);
    }

    @VisibleForTesting
    Component findOrCreateComponent(StorageTx tx, String packageId, String version) {
        Component component = OrientNugetComponentHelper.findComponent((StorageTx)tx, (String)packageId, (String)version, Collections.singletonList(this.getRepository()));
        if (component == null) {
            Repository repository = this.getRepository();
            component = OrientNugetComponentHelper.createComponent((StorageTx)tx, (Repository)repository, (String)packageId, (String)version);
        }
        return component;
    }

    @VisibleForTesting
    Asset findOrCreateAsset(StorageTx tx, Component component) {
        Asset asset = tx.firstAsset(component);
        if (asset == null) {
            asset = tx.createAsset(tx.findBucket(this.getRepository()), component);
            asset.name(String.valueOf(component.name()) + "/" + component.version());
        }
        return asset;
    }

    @Override
    protected void delete(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        String path = this.getItemPath(change);
        try {
            this.inStorageTx(() -> {
                StorageTx tx = (StorageTx)UnitOfWork.currentTx();
                Component migratedComponent = this.findMigratedComponent(tx, path);
                if (migratedComponent == null) {
                    this.log.warn("Unable to find and delete component associated with item path {}", (Object)path);
                    return null;
                }
                tx.deleteComponent(migratedComponent);
                return null;
            });
        }
        catch (IOException e) {
            this.log.warn("Exception while processing delete change: {}", (Object)change, (Object)e);
        }
    }

    private Component findMigratedComponent(StorageTx tx, String itemPath) {
        String pathKey = "attributes.migration.path";
        return (Component)Iterables.getFirst((Iterable)tx.findComponents(Query.builder().where(pathKey).eq((Object)itemPath).build(), Collections.singletonList(this.getRepository())), null);
    }

    @Override
    protected void streamContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TempBlob blob = this.getTempBlob(change);){
            if (blob == null) {
                return;
            }
            this.inStorageTx(() -> {
                NugetPackageCoords coords;
                StorageTx tx = (StorageTx)UnitOfWork.currentTx();
                Component component = OrientNugetComponentHelper.findComponent((StorageTx)tx, (String)(coords = this.nugetCoords(change)).getId(), (String)coords.getVersion(), Collections.singletonList(this.getRepository()));
                Preconditions.checkState((component != null ? 1 : 0) != 0);
                Asset asset = tx.firstAsset(component);
                Preconditions.checkState((asset != null ? 1 : 0) != 0);
                tx.setBlob(asset, OrientNugetComponentHelper.blobName((Component)component), blob, null, this.getContentType(change), true);
                this.applyLastModified(change, asset);
                tx.saveAsset(asset);
                return null;
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void applyLastModified(RepositoryChangelogClient.ChangeEntryXO change, Asset asset) {
        DateTime lastUpdated = this.getLastUpdated(change);
        if (lastUpdated != null) {
            Content.applyToAsset((Asset)asset, (AttributesMap)new AttributesMap((Map)ImmutableMap.of((Object)"last_modified", (Object)lastUpdated)));
        }
        DateTime uploadedDate = this.getLastUploaded(change);
        asset.blobCreated(uploadedDate);
        asset.blobUpdated(lastUpdated);
    }

    @Override
    public List<HashAlgorithm> getRequiredHashAlgorithms() {
        return NugetPackageUtils.HASH_ALGORITHMS;
    }

    @Override
    protected void hardLinkContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        this.inStorageTx(() -> {
            NugetPackageCoords coords;
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Component component = OrientNugetComponentHelper.findComponent((StorageTx)tx, (String)(coords = this.nugetCoords(change)).getId(), (String)coords.getVersion(), Collections.singletonList(this.getRepository()));
            Preconditions.checkState((component != null ? 1 : 0) != 0);
            Asset asset = tx.firstAsset(component);
            Preconditions.checkState((asset != null ? 1 : 0) != 0);
            tx.setBlob(asset, OrientNugetComponentHelper.blobName((Component)component), this.getStoragePath(change), this.getHashCodes(change), null, this.getContentType(change), this.getSize(change));
            tx.saveAsset(asset);
            return null;
        });
    }

    @Override
    @Nullable
    protected Asset getIngestedContent(StorageTx tx, RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        NugetPackageCoords coords = this.nugetCoords(change);
        Component component = OrientNugetComponentHelper.findComponent((StorageTx)tx, (String)coords.getId(), (String)coords.getVersion(), Collections.singletonList(this.getRepository()));
        if (component == null) {
            return null;
        }
        return tx.firstAsset(component);
    }

    private NugetPackageCoords nugetCoords(RepositoryChangelogClient.ChangeEntryXO change) {
        String packageId = change.getChange().getComponent().getName();
        String version = change.getChange().getComponent().getVersion();
        return new NugetPackageCoords(packageId, version);
    }

    @Override
    protected Map<HashAlgorithm, HashCode> getHashCodes(RepositoryChangelogClient.ChangeEntryXO change) {
        ArrayList<HashAlgorithm> hashAlgorithms = new ArrayList<HashAlgorithm>(this.getRequiredHashAlgorithms());
        boolean includeSha512 = hashAlgorithms.remove(HashAlgorithm.SHA512);
        Map<HashAlgorithm, HashCode> hashes = this.getHashCodes(change, hashAlgorithms);
        if (includeSha512) {
            NestedAttributesMap nugetAttributes = change.getChange().getAsset().attributes().child(NUGET);
            Preconditions.checkState((boolean)HashAlgorithm.SHA512.name().equalsIgnoreCase((String)nugetAttributes.get("PACKAGEHASHALGORITHM", String.class)));
            String packageHash = (String)Preconditions.checkNotNull((Object)((String)nugetAttributes.get("PACKAGEHASH", String.class)));
            hashes.put(HashAlgorithm.SHA512, HashCode.fromBytes((byte[])Base64.getDecoder().decode(packageHash)));
        }
        return hashes;
    }

    @Override
    public String calculatePath(RepositoryChangelogClient.ChangeEntryXO change) {
        return Optional.ofNullable(change.getChange().getComponent()).map(RepositoryChangelogClient.ComponentDetailXO::getName).orElseGet(() -> super.calculatePath(change));
    }
}

