/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository.migrators.datastore;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.repository.migrators.datastore.DatastoreRepositoryMigratorSupport;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.rubygems.datastore.RubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.marshal.GemSpecification;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.view.payloads.TempBlobPayload;

@Named(value="rubygems")
public class RubygemsRepositoryMigrator
extends DatastoreRepositoryMigratorSupport {
    @Override
    public List<HashAlgorithm> getRequiredHashAlgorithms() {
        return Arrays.asList(HashAlgorithm.MD5, HashAlgorithm.SHA1, HashAlgorithm.SHA256);
    }

    @Override
    protected void delete(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        String path = this.nx2PathToNx3(change);
        RubygemsContentFacet facet = (RubygemsContentFacet)this.getRepository().facet(RubygemsContentFacet.class);
        facet.deleteGem(path);
    }

    @Override
    protected void recordMetadata(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        String path = this.getAssetName(change);
        if (path.endsWith(".gem")) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (TempBlob tempBlob = this.getTempBlob(change);){
                if (tempBlob == null) {
                    return;
                }
                RubygemsContentFacet rubygemsContentFacet = (RubygemsContentFacet)this.getRepository().facet(RubygemsContentFacet.class);
                Content content = rubygemsContentFacet.putGem((Payload)new TempBlobPayload(tempBlob));
                GemSpecification gemspec = (GemSpecification)content.getAttributes().require(GemSpecification.class);
                rubygemsContentFacet.putGemSpec(gemspec);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    @Override
    @Nullable
    protected Asset getIngestedContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        String path = this.getAssetName(change);
        return this.assets().path(path).find().orElse(null);
    }

    private String nx2PathToNx3(RepositoryChangelogClient.ChangeEntryXO change) {
        String path = (String)Preconditions.checkNotNull((Object)change.getChange().getPath());
        if (path.endsWith(".gem")) {
            return "gems" + path.substring(path.lastIndexOf(47));
        }
        return path;
    }
}

