/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository.migrators.datastore;

import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.repository.migrators.datastore.DatastoreRepositoryMigratorSupport;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.content.raw.RawContentFacet;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;

@Named(value="raw-hosted")
public class RawHostedRepositoryMigrator
extends DatastoreRepositoryMigratorSupport {
    @Override
    @Nullable
    protected Asset getIngestedContent(RepositoryChangelogClient.ChangeEntryXO change) {
        RawContentFacet facet = (RawContentFacet)this.getRepository().facet(RawContentFacet.class);
        String componentName = this.getAssetName(change);
        String componentGroup = change.getChange().getComponent().getGroup();
        FluentComponent component = facet.components().name(componentName).namespace(componentGroup).getOrCreate();
        return component.asset(componentName).save();
    }

    @Override
    public List<HashAlgorithm> getRequiredHashAlgorithms() {
        return ImmutableList.of((Object)HashAlgorithm.MD5, (Object)HashAlgorithm.SHA1);
    }

    @Override
    protected void delete(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        RawContentFacet facet = (RawContentFacet)this.getRepository().facet(RawContentFacet.class);
        facet.delete(this.getAssetName(change));
    }

    @Override
    protected void recordMetadata(RepositoryChangelogClient.ChangeEntryXO change) {
        this.getIngestedContent(change);
    }
}

