/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository.migrators.datastore;

import com.sonatype.nexus.migration.assistant.MigrationAssistant;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.repository.IngestMethod;
import com.sonatype.nexus.migration.repository.migrators.datastore.NugetHostedRepositoryMigrator;
import com.sonatype.nexus.migration.repository.migrators.datastore.ProxyMetadataHelper;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named(value="nuget-proxy")
public class NugetProxyRepositoryMigrator
extends NugetHostedRepositoryMigrator {
    private final RepositoryManager repositoryManager;

    @Inject
    public NugetProxyRepositoryMigrator(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    @Override
    public void init(MigrationAssistant assistant, Repository repository, IngestMethod ingestMethod) {
        try {
            Configuration configuration = repository.getConfiguration().copy();
            configuration.attributes("nugetProxy").set("nugetVersion", (Object)"V2");
            this.repositoryManager.update(configuration);
            super.init(assistant, repository, ingestMethod);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected FluentAsset getOrCreateAsset(RepositoryChangelogClient.ChangeEntryXO change) {
        FluentAsset asset = super.getOrCreateAsset(change);
        ProxyMetadataHelper.updateProxyMetadata(change, asset);
        return asset;
    }
}

