/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository.migrators.datastore;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.repository.migrators.datastore.NugetRepositoryMigratorSupport;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;

@Named(value="nuget-hosted")
public class NugetHostedRepositoryMigrator
extends NugetRepositoryMigratorSupport {
    @Override
    protected Map<HashAlgorithm, HashCode> getHashCodes(RepositoryChangelogClient.ChangeEntryXO change) {
        ArrayList<HashAlgorithm> hashAlgorithms = new ArrayList<HashAlgorithm>(this.getRequiredHashAlgorithms());
        boolean includeSha512 = hashAlgorithms.remove(HashAlgorithm.SHA512);
        Map<HashAlgorithm, HashCode> hashes = this.getHashCodes(change, hashAlgorithms);
        if (includeSha512) {
            NestedAttributesMap nugetAttributes = change.getChange().getAsset().attributes().child("nuget");
            Preconditions.checkState((boolean)HashAlgorithm.SHA512.name().equalsIgnoreCase((String)nugetAttributes.get("PACKAGEHASHALGORITHM", String.class)));
            String packageHash = (String)Preconditions.checkNotNull((Object)((String)nugetAttributes.get("PACKAGEHASH", String.class)));
            hashes.put(HashAlgorithm.SHA512, HashCode.fromBytes((byte[])Base64.getDecoder().decode(packageHash)));
        }
        return hashes;
    }
}

