/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository.migrators.datastore;

import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.repository.migrators.datastore.DatastoreRepositoryMigratorSupport;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.content.maven.MavenContentFacet;
import org.sonatype.nexus.content.maven.store.Maven2ComponentStore;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenPath;

public class Maven2RepositoryMigratorSupport
extends DatastoreRepositoryMigratorSupport {
    protected static final String MAVEN2 = "maven2";

    @Override
    @Nullable
    protected Asset getIngestedContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        MavenPath.Coordinates coordinates = this.getMavenPath(change).getCoordinates();
        if (coordinates == null) {
            return null;
        }
        return this.components().name(coordinates.getArtifactId()).namespace(coordinates.getGroupId()).version(coordinates.getVersion()).find().flatMap(c -> c.asset(this.getAssetName(change)).find()).orElse(null);
    }

    @Override
    public List<HashAlgorithm> getRequiredHashAlgorithms() {
        return MavenPath.HashType.ALGORITHMS;
    }

    @Override
    protected void delete(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        MavenContentFacet facet = (MavenContentFacet)this.getRepository().facet(MavenContentFacet.class);
        facet.delete(this.getMavenPath(change));
    }

    @Override
    protected void recordMetadata(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        MavenPath mavenPath = this.getMavenPath(change);
        this.getOrCreateAsset(mavenPath, change);
    }

    @Override
    protected void streamContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        super.streamContent(change);
        ((MavenContentFacet)this.getRepository().facet(MavenContentFacet.class)).maybeUpdateComponentAttributes(this.getMavenPath(change));
    }

    @Override
    protected void hardLinkContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        super.hardLinkContent(change);
        ((MavenContentFacet)this.getRepository().facet(MavenContentFacet.class)).maybeUpdateComponentAttributes(this.getMavenPath(change));
    }

    protected FluentAsset getOrCreateAsset(MavenPath mavenPath, RepositoryChangelogClient.ChangeEntryXO change) {
        return mavenPath.getCoordinates() == null ? this.maybeCreateDetachedAsset(mavenPath, change) : this.maybeCreateAsset(mavenPath, change);
    }

    private String getAssetKind(RepositoryChangelogClient.ChangeEntryXO change) {
        return (String)change.getChange().getAsset().attributes().child(MAVEN2).get("asset_kind", String.class, (Object)"");
    }

    private FluentAsset maybeCreateDetachedAsset(MavenPath mavenPath, RepositoryChangelogClient.ChangeEntryXO change) {
        return this.assets().path(this.getAssetName(mavenPath)).kind(this.getAssetKind(change)).save();
    }

    private FluentAsset maybeCreateAsset(MavenPath mavenPath, RepositoryChangelogClient.ChangeEntryXO change) {
        MavenContentFacet facet = (MavenContentFacet)this.getRepository().facet(MavenContentFacet.class);
        return facet.createComponentAndAsset(mavenPath);
    }

    protected MavenPath getMavenPath(RepositoryChangelogClient.ChangeEntryXO change) {
        return ((MavenFacet)this.getRepository().facet(MavenFacet.class)).getMavenPathParser().parsePath(this.getAssetName(change), false);
    }

    protected String getAssetName(MavenPath mavenPath) {
        return "/" + mavenPath.getPath();
    }

    private Maven2ComponentStore componentStore() {
        return (Maven2ComponentStore)((ContentFacetSupport)this.content()).stores().componentStore;
    }
}

