/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository.migrators.datastore;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.repository.IngestMethod;
import com.sonatype.nexus.migration.repository.migrators.datastore.Maven2RepositoryMigratorSupport;
import com.sonatype.nexus.migration.repository.migrators.datastore.ProxyMetadataHelper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import org.sonatype.nexus.content.maven.MavenContentFacet;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;

@Named(value="maven2-proxy")
public class Maven2ProxyRepositoryMigrator
extends Maven2RepositoryMigratorSupport {
    private static final String REPOSITORY_METADATA = "REPOSITORY_METADATA";
    private static final String ARTIFACT_SUBORDINATE = "ARTIFACT_SUBORDINATE";
    private static final String OTHER = "OTHER";

    @Override
    protected void ingestContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        MavenPath mavenPath = this.getMavenPath(change);
        super.ingestContent(change);
        if (IngestMethod.DOWNLOAD != this.getIngestMethod()) {
            this.maybeCreateHashAssets(mavenPath);
        }
    }

    private void maybeCreateHashAssets(MavenPath mavenPath) throws IOException {
        if (mavenPath.isSignature() || mavenPath.getPath().endsWith(".asc")) {
            this.log.trace("maybeCreateHashAssets - skipping signature: {}", (Object)mavenPath);
            return;
        }
        Optional optionalAsset = this.assets().path(this.getAssetName(mavenPath)).find();
        if (optionalAsset.isPresent()) {
            FluentAsset asset = (FluentAsset)optionalAsset.get();
            MavenContentFacet mavenFacet = (MavenContentFacet)this.getRepository().facet(MavenContentFacet.class);
            MavenPathParser mavenPathParser = mavenFacet.getMavenPathParser();
            Optional optionalBlob = asset.blob();
            if (optionalBlob.isPresent()) {
                AssetBlob blob = (AssetBlob)optionalBlob.get();
                for (Map.Entry checksum : blob.checksums().entrySet()) {
                    MavenPath hashPath = mavenPathParser.parsePath(String.valueOf(mavenPath.getPath()) + "." + (String)checksum.getKey());
                    this.log.trace("maybeCreateHashAssets - creating hash: {}", (Object)hashPath);
                    mavenFacet.put(hashPath, (Payload)new BytesPayload(((String)checksum.getValue()).getBytes(StandardCharsets.UTF_8), "text/plain"));
                }
            }
        }
    }

    private String getHashAssetKind(MavenPath mavenPath) {
        Preconditions.checkState((boolean)mavenPath.isHash(), (String)"expected a maven path to a hash file: %s", (Object)mavenPath);
        MavenPathParser mavenPathParser = ((MavenFacet)this.getRepository().facet(MavenFacet.class)).getMavenPathParser();
        if (mavenPathParser.isRepositoryMetadata(mavenPath)) {
            return REPOSITORY_METADATA;
        }
        if (mavenPath.isSubordinate()) {
            return ARTIFACT_SUBORDINATE;
        }
        return OTHER;
    }

    @Override
    public void processChange(RepositoryChangelogClient.ChangeEntryXO change) throws Exception {
        String itemPath = this.getItemPath(change);
        if (IngestMethod.DOWNLOAD != this.getIngestMethod() && (itemPath.endsWith(".md5") || itemPath.endsWith(".sha1"))) {
            this.log.trace("processChange - skipping: {}", (Object)change);
        } else {
            super.processChange(change);
        }
    }

    @Override
    protected FluentAsset getOrCreateAsset(MavenPath mavenPath, RepositoryChangelogClient.ChangeEntryXO change) {
        FluentAsset asset = super.getOrCreateAsset(mavenPath, change);
        ProxyMetadataHelper.updateProxyMetadata(change, asset);
        return asset;
    }
}

