/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository.migrators.datastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.firewall.datastore.DatastoreFirewallMigrationFacade;
import com.sonatype.nexus.migration.repository.RepositoryMigrator;
import com.sonatype.nexus.migration.repository.migrators.RepositoryMigratorSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.fluent.FluentBlobs;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

public abstract class DatastoreRepositoryMigratorSupport
extends RepositoryMigratorSupport
implements RepositoryMigrator {
    private DatastoreFirewallMigrationFacade firewallMigrationFacade;

    @Inject
    public void setFirewallMigrationFacade(DatastoreFirewallMigrationFacade firewallMigrationFacade) {
        this.firewallMigrationFacade = (DatastoreFirewallMigrationFacade)Preconditions.checkNotNull((Object)firewallMigrationFacade);
    }

    @Override
    protected void createOrUpdateFirewall(RepositoryChangelogClient.ChangeEntryXO change) {
        this.firewallMigrationFacade.maybeRecordAssetAttributes(this.getRepository(), change, () -> {
            try {
                return this.getIngestedContent(change);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    @Nullable
    protected abstract Asset getIngestedContent(RepositoryChangelogClient.ChangeEntryXO var1) throws IOException;

    @Override
    protected String getAssetName(RepositoryChangelogClient.ChangeEntryXO change) {
        return change.getChange().getPath();
    }

    @Override
    protected TempBlob createTempBlob(InputStream inputStream, Map<String, String> headers, Iterable<HashAlgorithm> hashAlgorithms) {
        return ((ContentFacet)this.getRepository().facet(ContentFacet.class)).blobs().ingest(inputStream, null, headers, hashAlgorithms);
    }

    protected ContentFacet content() {
        return (ContentFacet)this.getRepository().facet(ContentFacet.class);
    }

    protected FluentComponents components() {
        return this.content().components();
    }

    protected FluentAssets assets() {
        return this.content().assets();
    }

    protected FluentBlobs blobs() {
        return this.content().blobs();
    }

    protected void applyLastModified(RepositoryChangelogClient.ChangeEntryXO change, FluentAsset asset) {
        asset.attributes(AttributeOperation.OVERLAY, "content", (Object)ImmutableMap.of((Object)"last_modified", (Object)this.getLastUpdated(change).toString()));
    }

    @Override
    protected void streamContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        ImmutableMap.Builder headers = ImmutableMap.builder();
        String uploadedBy = this.getUploadedBy(change);
        String uploadedByIp = this.getUploadedByIp(change);
        if (uploadedBy != null) {
            headers.put((Object)"BlobStore.created-by", (Object)uploadedBy);
        }
        if (uploadedByIp != null) {
            headers.put((Object)"BlobStore.created-by-ip", (Object)uploadedByIp);
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob blob = this.getTempBlob(change, (Map<String, String>)headers.build());){
            if (blob == null) {
                return;
            }
            this.findAsset(this.getAssetName(change)).ifPresent(asset -> {
                this.applyLastModified(change, (FluentAsset)asset);
                asset.attach(blob);
                this.maybeUpdateAssetTimestamps((FluentAsset)asset, change);
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void hardLinkContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        this.findAsset(this.getAssetName(change)).ifPresent(asset -> {
            this.applyLastModified(change, (FluentAsset)asset);
            String uploadedBy = this.getUploadedBy(change);
            String uploadedByIp = this.getUploadedByIp(change);
            ImmutableMap.Builder headers = ImmutableMap.builder();
            headers.put((Object)"Bucket.repo-name", (Object)this.getRepository().getName());
            headers.put((Object)"BlobStore.blob-name", (Object)this.getItemPath(change));
            headers.put((Object)"BlobStore.content-type", (Object)Optional.ofNullable(this.getContentType(change)).orElse("application/octet-stream"));
            if (uploadedBy != null) {
                headers.put((Object)"BlobStore.created-by", (Object)uploadedBy);
            }
            if (uploadedByIp != null) {
                headers.put((Object)"BlobStore.created-by-ip", (Object)uploadedByIp);
            }
            Map<HashAlgorithm, HashCode> hashes = this.getHashCodes(change);
            Blob blob = this.blobs().ingest(this.getStoragePath(change), (Map)headers.build(), hashes.get(HashAlgorithm.SHA1), this.getSize(change));
            asset.attach(blob, hashes);
            this.maybeUpdateAssetTimestamps((FluentAsset)asset, change);
        });
    }

    private void maybeUpdateAssetTimestamps(FluentAsset asset, RepositoryChangelogClient.ChangeEntryXO change) {
        OffsetDateTime uploadedDate = this.getUploadedDate(change);
        OffsetDateTime lastUpdated = this.getLastUpdatedDate(change);
        OffsetDateTime lastDownloaded = this.getLastDownloadedDate(change);
        this.log.trace("Found uploadedDate {} and lastUpdated {} and lastDownloaded {} dates from nxrm2 for asset {}", new Object[]{uploadedDate, lastUpdated, lastDownloaded, asset.path()});
        if (uploadedDate != null) {
            asset.created(uploadedDate);
            asset.blobCreated(uploadedDate);
            if (lastUpdated != null) {
                asset.lastUpdated(lastUpdated);
            }
        } else if (lastUpdated != null) {
            asset.created(lastUpdated);
            asset.blobCreated(lastUpdated);
            asset.lastUpdated(lastUpdated);
        }
        if (lastDownloaded != null) {
            asset.lastDownloaded(lastDownloaded);
        }
    }

    @Nullable
    protected String getUploadedBy(RepositoryChangelogClient.ChangeEntryXO change) {
        return (String)change.getChange().getAsset().attributes().child("custom").get("request.user", String.class);
    }

    @Nullable
    protected String getUploadedByIp(RepositoryChangelogClient.ChangeEntryXO change) {
        return (String)change.getChange().getAsset().attributes().child("custom").get("request.address", String.class);
    }

    @Nullable
    protected OffsetDateTime getUploadedDate(RepositoryChangelogClient.ChangeEntryXO change) {
        String uploadedDate = (String)change.getChange().getAsset().attributes().child("custom").get("storageItem-created", String.class);
        return uploadedDate == null ? null : OffsetDateTime.parse(new DateTime((Object)Long.valueOf(uploadedDate)).toString());
    }

    @Nullable
    protected OffsetDateTime getLastUpdatedDate(RepositoryChangelogClient.ChangeEntryXO change) {
        String lastUpdatedDate = (String)change.getChange().getAsset().attributes().child("content").get("last_updated", String.class);
        return lastUpdatedDate == null ? null : OffsetDateTime.parse(lastUpdatedDate);
    }

    @Nullable
    protected OffsetDateTime getLastDownloadedDate(RepositoryChangelogClient.ChangeEntryXO change) {
        String lastDownloadedDate = (String)change.getChange().getAsset().attributes().child("content").get("last_accessed", String.class);
        return lastDownloadedDate == null ? null : OffsetDateTime.parse(lastDownloadedDate);
    }

    protected Optional<FluentAsset> findAsset(String path) {
        return this.assets().path(path).find();
    }
}

