/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Enums;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.migration.MigrationService;
import com.sonatype.nexus.migration.assistant.MigrationPhases;
import com.sonatype.nexus.migration.client.RepositoryMigrationClient;
import com.sonatype.nexus.migration.plan.Step;
import com.sonatype.nexus.migration.repository.RepositoryScanStatus;
import com.sonatype.nexus.migration.repository.RepositoryStepSupport;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.sonatype.goodies.common.Time;

@Named(value="migration.repositories-scan")
public class RepositoriesScanStep
extends RepositoryStepSupport {
    @Inject
    private RepositoryMigrationClient repositoryMigrationClient;
    @Inject
    private MigrationService migrationService;
    @VisibleForTesting
    private int scannedRepositoriesCount;
    @VisibleForTesting
    private Set<String> repositoriesToScan;
    public static final String TYPE_NAME = "migration.repositories-scan";
    @VisibleForTesting
    private Time DELAY;
    private AtomicBoolean stopProcessing;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public RepositoriesScanStep() {
        CallSite[] callSiteArray = RepositoriesScanStep.$getCallSiteArray();
        Object object = callSiteArray[0].callConstructor(HashSet.class);
        this.repositoriesToScan = (Set)ScriptBytecodeAdapter.castToType((Object)object, Set.class);
        Object object2 = callSiteArray[1].call(Time.class, (Object)15);
        this.DELAY = (Time)ScriptBytecodeAdapter.castToType((Object)object2, Time.class);
        Object object3 = callSiteArray[2].callConstructor(AtomicBoolean.class, (Object)false);
        this.stopProcessing = (AtomicBoolean)ScriptBytecodeAdapter.castToType((Object)object3, AtomicBoolean.class);
    }

    @Override
    public String getType() {
        CallSite[] callSiteArray = RepositoriesScanStep.$getCallSiteArray();
        return TYPE_NAME;
    }

    @Override
    protected void doInit() {
        CallSite[] callSiteArray = RepositoriesScanStep.$getCallSiteArray();
        callSiteArray[3].call(this.repositoriesToScan, callSiteArray[4].callGroovyObjectGetProperty((Object)this));
    }

    @Override
    protected void doConfigure(Map<String, Object> config) {
        CallSite[] callSiteArray = RepositoriesScanStep.$getCallSiteArray();
        Object object = callSiteArray[5].callGetProperty(MigrationPhases.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, RepositoriesScanStep.class, (GroovyObject)this, (String)"phase");
        Object object2 = callSiteArray[6].callGetProperty(config);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object2, RepositoriesScanStep.class, (GroovyObject)this, (String)"selectedRepositories");
        GStringImpl gStringImpl = new GStringImpl(new Object[]{callSiteArray[7].call(callSiteArray[8].callGetProperty(config))}, new String[]{"Scan ", " repositories"});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)gStringImpl, RepositoriesScanStep.class, (GroovyObject)this, (String)"name");
    }

    @Override
    protected void doRun() {
        CallSite[] callSiteArray = RepositoriesScanStep.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[9].callCurrent((GroovyObject)this);
        } else {
            this.updateStatus();
        }
        while (DefaultTypeTransformation.booleanUnbox(this.repositoriesToScan) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[10].callCurrent((GroovyObject)this))) {
            public final class _doRun_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _doRun_closure1(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _doRun_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object repository) {
                    CallSite[] callSiteArray = _doRun_closure1.$getCallSiteArray();
                    return callSiteArray[0].callCurrent((GroovyObject)this, repository);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _doRun_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "checkRepositoryStatus";
                    return new CallSiteArray(_doRun_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _doRun_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].call(this.repositoriesToScan, (Object)new _doRun_closure1((Object)this, (Object)this)))) {
                callSiteArray[12].callCurrent((GroovyObject)this);
            }
            if (!(ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[13].call(this.repositoriesToScan), (Object)0) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].callCurrent((GroovyObject)this)))) continue;
            callSiteArray[15].call((Object)this.DELAY);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].call((Object)this.stopProcessing))) {
            callSiteArray[17].call(callSiteArray[18].callGroovyObjectGetProperty((Object)this), (Object)"Repository scanning stopped prior to completion");
        }
    }

    @Override
    public boolean isAborted() {
        CallSite[] callSiteArray = RepositoriesScanStep.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[19].call((Object)this.stopProcessing)) || DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(RepositoryStepSupport.class, (GroovyObject)this, (String)"isAborted"));
    }

    public boolean stopProcessing() {
        CallSite[] callSiteArray = RepositoriesScanStep.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[20].callGetProperty((Object)this.migrationService))) {
            callSiteArray[21].call((Object)this.stopProcessing, (Object)true);
            return true;
        }
        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[22].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[23].callGetProperty(Step.State.class));
    }

    private void updateStatus() {
        CallSite[] callSiteArray = RepositoriesScanStep.$getCallSiteArray();
        GStringImpl status = new GStringImpl(new Object[]{this.scannedRepositoriesCount, callSiteArray[24].call(callSiteArray[25].callGroovyObjectGetProperty((Object)this))}, new String[]{"Scanned ", " of ", " repositories"});
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[26].call((Object)this.stopProcessing))) {
            GStringImpl gStringImpl;
            status = gStringImpl = new GStringImpl(new Object[]{status}, new String[]{"Scanning Stopped. ", ""});
        }
        callSiteArray[27].callCurrent((GroovyObject)this, (Object)status);
        callSiteArray[28].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)Float.valueOf(DefaultTypeTransformation.floatUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[29].call((Object)this.scannedRepositoriesCount, callSiteArray[30].call(callSiteArray[31].callGroovyObjectGetProperty((Object)this))), Float.TYPE))), Float.TYPE));
        callSiteArray[32].call(callSiteArray[33].callGroovyObjectGetProperty((Object)this), (Object)"{}, remaining repositories: {}", (Object)status, this.repositoriesToScan);
    }

    private boolean checkRepositoryStatus(String repository) {
        CallSite[] callSiteArray = RepositoriesScanStep.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass() ? DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[34].callCurrent((GroovyObject)this)) : this.isAborted()) {
            return false;
        }
        Object repositoryMigrationStatus = callSiteArray[35].call((Object)this.repositoryMigrationClient, callSiteArray[36].callGetProperty((Object)this.migrationService), (Object)repository);
        callSiteArray[37].callStatic(Preconditions.class, (Object)ScriptBytecodeAdapter.compareNotEqual((Object)repositoryMigrationStatus, null), (Object)"Failed to fetch repository status from remote agent");
        Object scanStatus = callSiteArray[38].call(Enums.class, RepositoryScanStatus.class, callSiteArray[39].callGetProperty(repositoryMigrationStatus));
        callSiteArray[40].callStatic(Preconditions.class, callSiteArray[41].callGetProperty(scanStatus), (Object)new GStringImpl(new Object[]{callSiteArray[42].callGetProperty(repositoryMigrationStatus)}, new String[]{"Unexpected status ", ""}));
        Object scanStatusCode = callSiteArray[43].call(scanStatus);
        callSiteArray[44].callStatic(Preconditions.class, (Object)ScriptBytecodeAdapter.compareNotEqual((Object)scanStatusCode, (Object)callSiteArray[45].callGetProperty(RepositoryScanStatus.class)), (Object)"Scan cancelled");
        callSiteArray[46].callStatic(Preconditions.class, (Object)ScriptBytecodeAdapter.compareNotEqual((Object)scanStatusCode, (Object)callSiteArray[47].callGetProperty(RepositoryScanStatus.class)), (Object)"Scan failed");
        if (ScriptBytecodeAdapter.compareEqual((Object)scanStatusCode, (Object)callSiteArray[48].callGetProperty(RepositoryScanStatus.class))) {
            if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                int n = this.scannedRepositoriesCount;
                this.scannedRepositoriesCount = DefaultTypeTransformation.intUnbox((Object)callSiteArray[49].call((Object)n));
            } else {
                int n = this.scannedRepositoriesCount;
                this.scannedRepositoriesCount = n + 1;
            }
            return true;
        }
        return false;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != RepositoriesScanStep.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public RepositoryMigrationClient getRepositoryMigrationClient() {
        return this.repositoryMigrationClient;
    }

    @Generated
    public void setRepositoryMigrationClient(RepositoryMigrationClient repositoryMigrationClient) {
        this.repositoryMigrationClient = repositoryMigrationClient;
    }

    @Generated
    public MigrationService getMigrationService() {
        return this.migrationService;
    }

    @Generated
    public void setMigrationService(MigrationService migrationService) {
        this.migrationService = migrationService;
    }

    @Generated
    public int getScannedRepositoriesCount() {
        return this.scannedRepositoriesCount;
    }

    @Generated
    public void setScannedRepositoriesCount(int n) {
        this.scannedRepositoriesCount = n;
    }

    @Generated
    public Set<String> getRepositoriesToScan() {
        return this.repositoriesToScan;
    }

    @Generated
    public void setRepositoriesToScan(Set<String> set) {
        this.repositoriesToScan = set;
    }

    @Generated
    public Time getDELAY() {
        return this.DELAY;
    }

    @Generated
    public void setDELAY(Time time) {
        this.DELAY = time;
    }

    public /* synthetic */ void super$3$doInit() {
        super.doInit();
    }

    public /* synthetic */ boolean super$3$isAborted() {
        return super.isAborted();
    }

    public /* synthetic */ MetaClass super$4$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ void super$3$doConfigure(Map map) {
        super.doConfigure(map);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "seconds";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "addAll";
        stringArray[4] = "selectedRepositories";
        stringArray[5] = "SYNC";
        stringArray[6] = "selectedRepositories";
        stringArray[7] = "size";
        stringArray[8] = "selectedRepositories";
        stringArray[9] = "updateStatus";
        stringArray[10] = "isAborted";
        stringArray[11] = "removeAll";
        stringArray[12] = "updateStatus";
        stringArray[13] = "size";
        stringArray[14] = "isAborted";
        stringArray[15] = "sleep";
        stringArray[16] = "get";
        stringArray[17] = "info";
        stringArray[18] = "log";
        stringArray[19] = "get";
        stringArray[20] = "forceContinueEnabled";
        stringArray[21] = "set";
        stringArray[22] = "state";
        stringArray[23] = "COMPLETED";
        stringArray[24] = "size";
        stringArray[25] = "selectedRepositories";
        stringArray[26] = "get";
        stringArray[27] = "setStatus";
        stringArray[28] = "setComplete";
        stringArray[29] = "div";
        stringArray[30] = "size";
        stringArray[31] = "selectedRepositories";
        stringArray[32] = "debug";
        stringArray[33] = "log";
        stringArray[34] = "isAborted";
        stringArray[35] = "status";
        stringArray[36] = "assistant";
        stringArray[37] = "checkState";
        stringArray[38] = "getIfPresent";
        stringArray[39] = "scanStatus";
        stringArray[40] = "checkState";
        stringArray[41] = "present";
        stringArray[42] = "scanStatus";
        stringArray[43] = "get";
        stringArray[44] = "checkState";
        stringArray[45] = "CANCELLED";
        stringArray[46] = "checkState";
        stringArray[47] = "FAILED";
        stringArray[48] = "FINISHED";
        stringArray[49] = "next";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[50];
        RepositoriesScanStep.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(RepositoriesScanStep.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = RepositoriesScanStep.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

