/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Supplier;

public class BufferingIterator<T>
implements Iterator<T> {
    private final Queue<T> buffer = new LinkedList<T>();
    private final Supplier<Iterable<T>> supplier;

    public BufferingIterator(Supplier<Iterable<T>> supplier) {
        this.supplier = (Supplier)Preconditions.checkNotNull(supplier);
    }

    @Override
    public boolean hasNext() {
        this.ensureBufferFilled();
        return !this.buffer.isEmpty();
    }

    @Override
    public T next() {
        this.ensureBufferFilled();
        return Optional.ofNullable(this.buffer.poll()).orElseThrow(NoSuchElementException::new);
    }

    private void ensureBufferFilled() {
        if (this.buffer.isEmpty()) {
            this.fillBuffer();
        }
    }

    private void fillBuffer() {
        this.supplier.get().forEach(this.buffer::add);
    }
}

