/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.plan;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.migration.plan.PhaseStep;
import com.sonatype.nexus.migration.plan.Plan;
import com.sonatype.nexus.migration.plan.ProgressLog;
import com.sonatype.nexus.migration.plan.StepContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Internal;
import org.sonatype.nexus.common.stateguard.StateGuard;
import org.sonatype.nexus.common.text.Plural;
import org.sonatype.nexus.upgrade.plan.Dependency;
import org.sonatype.nexus.upgrade.plan.DependencySource;

public abstract class Step
extends ComponentSupport
implements DependencySource<Step>,
DependencySource.DependsOnAware<Step>,
DependencySource.UnresolvedDependencyAware<Step> {
    protected String id;
    protected String name;
    protected String phase;
    protected final List<Dependency<Step>> dependencies = new ArrayList<Dependency<Step>>();
    protected Collection<Step> dependsOn = Collections.emptyList();
    protected volatile float complete;
    protected volatile String status;
    protected volatile boolean aborted;
    protected final StateGuard states = new StateGuard.Builder().logger(this.createLogger()).initial("NEW").failure("FAILED").create();
    protected final ProgressLog progressLog = new ProgressLog();
    protected Isolation isolation = Isolation.NONE;
    @Internal
    protected Map<String, Object> config;
    protected Plan plan;

    public abstract String getType();

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Isolation getIsolation() {
        return this.isolation;
    }

    public List<Dependency<Step>> getDependencies() {
        return this.dependencies;
    }

    public void setDependsOn(Collection<Step> dependsOn) {
        this.dependsOn = dependsOn;
    }

    public Collection<Step> getDependsOn() {
        return this.dependsOn;
    }

    public String getPhase() {
        return this.phase;
    }

    public String getState() {
        return this.states.getCurrent();
    }

    public float getComplete() {
        return this.complete;
    }

    void setComplete(float complete) {
        this.complete = complete;
    }

    public String getStatus() {
        return this.status;
    }

    void setStatus(String status) {
        this.status = status;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public ProgressLog getProgressLog() {
        return this.progressLog;
    }

    protected Map<String, Object> getConfiguration() {
        return this.config;
    }

    public void configure(Map<String, Object> config) throws Exception {
        this.states.transition("CONFIGURED").from(new String[]{"NEW"}).run(() -> {
            Preconditions.checkNotNull((Object)config);
            this.log.debug("Configuring {}", (Object)config);
            this.doConfigure(config);
            this.config = config;
            this.log.debug("Configured ${}", (Object)this.name);
            return config;
        });
    }

    protected void doConfigure(Map<String, Object> config) {
    }

    public void init(Plan plan) {
        this.plan = (Plan)((Object)Preconditions.checkNotNull((Object)((Object)plan)));
        Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"Missing: name");
        Preconditions.checkState((this.phase != null ? 1 : 0) != 0, (Object)"Missing: phase");
        if (this.id == null) {
            this.id = UUID.randomUUID().toString();
        }
        StepContext.bind(this);
        try {
            try {
                this.states.transition("INITIALIZED").from(new String[]{"CONFIGURED"}).run(() -> {
                    this.log.debug("Initializing {}", (Object)this.name);
                    this.complete = -1.0f;
                    this.status = "Pending";
                    if (!(this instanceof PhaseStep)) {
                        this.dependencies.add(PhaseStep.begin(this.phase));
                    }
                    this.doInit();
                    this.progressLog.add("Initialized", new Object[0]);
                    return null;
                });
            }
            catch (Exception e) {
                this.log.warn("{} failed", (Object)this.name, (Object)e);
                this.progressLog.add("Failed: " + e.getMessage(), new Object[0]);
                this.status = "Failed: " + e.getMessage();
                StepContext.unbind();
            }
        }
        finally {
            StepContext.unbind();
        }
    }

    protected void doInit() {
    }

    public void setUnresolvedDependencies(Collection<Dependency<Step>> unresolved) throws Exception {
        this.states.transition("FAILED").run(() -> {
            String message = Plural.of((int)unresolved.size(), (String)"unresolved dependency", (String)"unresolved dependencies");
            this.log.warn(message);
            this.status = message;
            this.progressLog.add(String.valueOf(message) + ": " + unresolved.stream().map(Object::toString).collect(Collectors.joining(", ")), new Object[0]);
            return null;
        });
    }

    public void run() throws Exception {
        block7: {
            this.states.transition("RUNNING").from(new String[]{"INITIALIZED"}).run(() -> {
                this.log.info("Running {}", (Object)this.name);
                this.progressLog.add("Running", new Object[0]);
                this.status = "Running ...";
                this.complete = 0.0f;
                return null;
            });
            StepContext.bind(this);
            try {
                try {
                    this.doRun();
                }
                catch (Exception e) {
                    if (!(e instanceof InterruptedException) || !this.aborted) {
                        this.states.transition("FAILED").run(() -> {
                            this.log.warn(" failed", (Object)this.name, (Object)e);
                            this.progressLog.add("Failed: " + e.getMessage(), new Object[0]);
                            this.status = "Failed: " + e.getMessage();
                            return null;
                        });
                    }
                    StepContext.unbind();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                StepContext.unbind();
                throw throwable;
            }
            StepContext.unbind();
        }
        if (this.aborted) {
            return;
        }
        this.states.transition("COMPLETED").from(new String[]{"RUNNING"}).run(() -> {
            this.log.debug("Completed ", (Object)this.name);
            this.progressLog.add("Completed", new Object[0]);
            this.status = "Completed";
            this.complete = 1.0f;
            return null;
        });
    }

    protected abstract void doRun();

    public void abort() throws Exception {
        this.states.transition("ABORTED").run(() -> {
            this.log.info("Aborting {}", (Object)this.name);
            this.aborted = true;
            this.progressLog.add("Aborting", new Object[0]);
            StepContext.bind(this);
            try {
                this.doAbort();
            }
            finally {
                StepContext.unbind();
            }
            this.log.info("Aborted {}", (Object)this.name);
            this.progressLog.add("Aborted", new Object[0]);
            return null;
        });
    }

    protected void doAbort() {
    }

    public void destroy() throws Exception {
        this.states.transition("DESTROYED").run(() -> {
            this.log.debug("Destroying {}", (Object)this.name);
            StepContext.bind(this);
            try {
                this.doDestroy();
            }
            finally {
                StepContext.unbind();
            }
            this.complete = -1.0f;
            this.status = null;
            this.plan = null;
            this.progressLog.clear();
            this.log.debug("Destroyed {}", (Object)this.name);
            return null;
        });
    }

    protected void doDestroy() {
    }

    public static enum Isolation {
        NONE,
        SINGLE;

    }

    public final class State {
        public static final String NEW = "NEW";
        public static final String CONFIGURED = "CONFIGURED";
        public static final String INITIALIZED = "INITIALIZED";
        public static final String RUNNING = "RUNNING";
        public static final String ABORTED = "ABORTED";
        public static final String COMPLETED = "COMPLETED";
        public static final String DESTROYED = "DESTROYED";
        public static final String FAILED = "FAILED";
    }
}

