/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.plan;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.migration.MigrationService;
import com.sonatype.nexus.migration.plan.PhaseEndStep;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskScheduler;

@Named(value="finish_phase.end")
public class FinishPhaseEndStep
extends PhaseEndStep {
    public static final String TYPE_NAME = "finish_phase.end";
    public static final String SEARCH_BUILD_TASK_NAME = "Repo 2 Migration - Build Search indexes for all repositories";
    public static final String BROWSE_BUILD_TASK_NAME = "Repo 2 Migration - Build Browse views for all repositories";
    private final TaskScheduler taskScheduler;
    private final MigrationService migrationService;

    @Inject
    public FinishPhaseEndStep(TaskScheduler taskScheduler, MigrationService migrationService) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.migrationService = (MigrationService)Preconditions.checkNotNull((Object)migrationService);
    }

    @Override
    public String getType() {
        return TYPE_NAME;
    }

    @Override
    protected void doRun() {
        this.maybeLaunchRebuildBrowseNodeTask();
        this.maybeLaunchRebuildSearchIndexTask();
    }

    private void maybeLaunchRebuildBrowseNodeTask() {
        if (!this.migrationService.isBuildBrowseEnabled()) {
            this.log.info("Starting rebuild of the browse nodes for all repositories");
            TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("create.browse.nodes");
            configuration.setString("repositoryName", "*");
            configuration.setName(BROWSE_BUILD_TASK_NAME);
            this.taskScheduler.submit(configuration);
        }
    }

    private void maybeLaunchRebuildSearchIndexTask() {
        if (!this.migrationService.isBuildSearchEnabled()) {
            this.log.info("Starting rebuild of the search index for all repositories");
            TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("repository.rebuild-index");
            configuration.setString("repositoryName", "*");
            configuration.setName(SEARCH_BUILD_TASK_NAME);
            this.taskScheduler.submit(configuration);
        }
    }
}

