/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.firewall.orient;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import com.sonatype.nexus.clm.migration.orient.OrientFirewallMigrationHelper;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.firewall.AbstractEnabledFirewallMigrationFacadeImpl;
import com.sonatype.nexus.migration.firewall.orient.OrientFirewallMigrationFacade;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
@Priority(value=0x7FFFFFFF)
public class OrientEnabledFirewallMigrationFacadeImpl
extends AbstractEnabledFirewallMigrationFacadeImpl<OrientFirewallMigrationHelper>
implements OrientFirewallMigrationFacade {
    private static final String IQ_ITEM_ATTRIBUTES = "iqItemAttributes";
    private static final TypeToken<Map<String, Object>> IQ_ITEM_ATTRIBUTES_TYPE = new TypeToken<Map<String, Object>>(){};

    @Inject
    public OrientEnabledFirewallMigrationFacadeImpl(OrientFirewallMigrationHelper firewallMigrationHelper, RepositoryManager repositoryManager) {
        super(firewallMigrationHelper, repositoryManager);
    }

    @Override
    public void maybeRecordAssetAttributes(Repository repository, RepositoryChangelogClient.ChangeEntryXO change, Function<StorageTx, Asset> assetLoader) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)change);
        Preconditions.checkNotNull(assetLoader);
        NestedAttributesMap assetAttributes = change.getChange().getAsset().attributes();
        Map iqAttributes = (Map)assetAttributes.get(IQ_ITEM_ATTRIBUTES, IQ_ITEM_ATTRIBUTES_TYPE);
        if (iqAttributes != null) {
            TransactionalStoreMetadata.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).run(() -> this.updateAssetAttributes(assetLoader, iqAttributes));
        }
    }

    private void updateAssetAttributes(Function<StorageTx, Asset> assetLoader, Map<String, Object> iqAttributes) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = assetLoader.apply(tx);
        if (asset != null) {
            ((OrientFirewallMigrationHelper)this.firewallMigrationHelper).ingestAssetAttributes(asset, iqAttributes);
            tx.saveAsset(asset);
        }
    }
}

