/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.config.ingesters;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.migration.config.ConfigurationIngesterSupport;
import com.sonatype.nexus.migration.config.PrincipalCollectionTranslator;
import com.sonatype.nexus.migration.plan.StepContext;
import com.sonatype.nexus.usertoken.plugin.UserTokenService;
import com.sonatype.nexus.usertoken.plugin.rest.model.exportimport.UserTokenRecordXO;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.subject.PrincipalCollection;
import org.sonatype.nexus.security.PasswordHelper;

@Named(value="security.user-tokens")
@Singleton
public class SecurityUserTokensIngester
extends ConfigurationIngesterSupport {
    public static final String NAME = "security.user-tokens";
    protected final UserTokenService userTokenService;
    protected final PasswordHelper passwordHelper;
    protected final PrincipalCollectionTranslator principalCollectionTranslator;

    @Inject
    public SecurityUserTokensIngester(UserTokenService userTokenService, PasswordHelper passwordHelper, PrincipalCollectionTranslator principalCollectionTranslator) {
        this.userTokenService = (UserTokenService)Preconditions.checkNotNull((Object)userTokenService);
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
        this.principalCollectionTranslator = (PrincipalCollectionTranslator)((Object)Preconditions.checkNotNull((Object)((Object)principalCollectionTranslator)));
    }

    @Override
    public void ingest() {
        StepContext context = StepContext.getCurrent();
        UserTokensXO config = this.get(Endpoint.class, Endpoint::get);
        this.userTokenService.setEnabled(true);
        this.userTokenService.removeAll();
        this.userTokenService.setProtectContent(config.protectContent);
        if (config.userTokens != null) {
            config.userTokens.forEach(userTokenXO -> {
                String user = userTokenXO.principals.stream().map(p -> p.principals).flatMap(Collection::stream).map(PrincipalCollectionTranslator.PrincipalXO::getPrincipalName).collect(Collectors.joining(", "));
                try {
                    this.userTokenService.insert(this.toRecord((UserTokenXO)userTokenXO), false);
                }
                catch (Exception e) {
                    this.log.warn("Failed to upgrade user token for '{}', ignoring", (Object)user, (Object)e);
                    context.log("Failed to upgrade user token for '%s', ignoring", user);
                }
            });
        }
        this.userTokenService.setEnabled(config.enabled);
    }

    UserTokenRecordXO toRecord(UserTokenXO xo) {
        UserTokenRecordXO record = new UserTokenRecordXO();
        record.setCreated(new Date(xo.createdTimestamp));
        record.setNameCode(xo.nameCode);
        record.setPassCode(this.passwordHelper.tryDecrypt(xo.passCode));
        PrincipalCollection collection = this.principalCollectionTranslator.translate(xo.principals, StepContext.getCurrent());
        Map principals = collection.getRealmNames().stream().collect(Collectors.toMap(Function.identity(), __ -> Collections.singletonList(collection.getPrimaryPrincipal().toString())));
        record.setPrincipalCollection(principals);
        return record;
    }

    public static interface Endpoint {
        @GET
        @Path(value="/configuration/security.user-tokens")
        @Produces(value={"application/json"})
        public UserTokensXO get(@HeaderParam(value="X-NX-Migration-Access-Token") String var1);
    }

    public static class UserTokenXO {
        List<PrincipalCollectionTranslator.PrincipalsXO> principals;
        String nameCode;
        String passCode;
        long createdTimestamp;

        public List<PrincipalCollectionTranslator.PrincipalsXO> getPrincipals() {
            return this.principals;
        }

        public void setPrincipals(List<PrincipalCollectionTranslator.PrincipalsXO> principals) {
            this.principals = principals;
        }

        public String getNameCode() {
            return this.nameCode;
        }

        public void setNameCode(String nameCode) {
            this.nameCode = nameCode;
        }

        public String getPassCode() {
            return this.passCode;
        }

        public void setPassCode(String passCode) {
            this.passCode = passCode;
        }

        public long getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public void setCreatedTimestamp(long createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public String toString() {
            return "UserTokenXO [principals=" + this.principals + ", nameCode=" + this.nameCode + ", passCode=*" + ", createdTimestamp=" + this.createdTimestamp + "]";
        }
    }

    public static class UserTokensXO {
        boolean enabled;
        boolean protectContent;
        List<UserTokenXO> userTokens;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isProtectContent() {
            return this.protectContent;
        }

        public void setProtectContent(boolean protectContent) {
            this.protectContent = protectContent;
        }

        public List<UserTokenXO> getUserTokens() {
            return this.userTokens;
        }

        public void setUserTokens(List<UserTokenXO> userTokens) {
            this.userTokens = userTokens;
        }

        public String toString() {
            return "UserTokensXO [enabled=" + this.enabled + ", protectContent=" + this.protectContent + ", userTokens=" + this.userTokens + "]";
        }
    }
}

