/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.config;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.migration.MigrationService;
import com.sonatype.nexus.migration.assistant.MigrationAssistant;
import com.sonatype.nexus.migration.config.ConfigurationIngester;
import java.util.function.BiFunction;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.client.Client;
import org.apache.commons.lang3.StringEscapeUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rest.client.RestClientConfiguration;
import org.sonatype.nexus.rest.client.RestClientFactory;

public abstract class ConfigurationIngesterSupport
extends ComponentSupport
implements ConfigurationIngester {
    private static final String NAME_INVALID_CHAR_REGEX = "^[^a-zA-Z0-9\\-]+|[^a-zA-Z0-9_\\-\\.]";
    protected RestClientFactory clientFactory;
    protected MigrationService migration;

    @Inject
    public void inject(@Named(value="migration") @Named(value="migration") RestClientFactory clientFactory, MigrationService migration) {
        this.clientFactory = (RestClientFactory)Preconditions.checkNotNull((Object)clientFactory);
        this.migration = (MigrationService)Preconditions.checkNotNull((Object)migration);
    }

    private Client client(RestClientConfiguration configuration) {
        return this.clientFactory.create(configuration);
    }

    protected Object get(String type) {
        MigrationAssistant assistant = this.migration.getAssistant();
        try (Client client = this.client(assistant.getRestClientConfiguration());){
            Endpoint endpoint = (Endpoint)this.clientFactory.proxy(Endpoint.class, client, assistant.getAgentUrl());
            Object object = endpoint.get(type, assistant.getAgentAccessToken());
            return object;
        }
    }

    protected <E, R> R get(Class<E> clazz, BiFunction<E, String, R> producer) {
        MigrationAssistant assistant = this.migration.getAssistant();
        try (Client client = this.client(assistant.getRestClientConfiguration());){
            Object endpoint = this.clientFactory.proxy(clazz, client, assistant.getAgentUrl());
            R r = producer.apply(endpoint, assistant.getAgentAccessToken());
            return r;
        }
    }

    protected String cleanName(String name) {
        if (name != null) {
            return this.htmlDecode(name).trim().replaceAll(" ", "_").replaceAll(NAME_INVALID_CHAR_REGEX, "");
        }
        return name;
    }

    protected String htmlDecode(String s) {
        return StringEscapeUtils.unescapeHtml4((String)s);
    }

    public static interface Endpoint {
        @GET
        @Path(value="/configuration/{type}")
        @Produces(value={"application/json"})
        public Object get(@PathParam(value="type") String var1, @HeaderParam(value="X-NX-Migration-Access-Token") String var2);
    }
}

