/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.client.internal;

import com.sonatype.nexus.migration.assistant.MigrationAssistant;
import com.sonatype.nexus.migration.client.RepositoryClient;
import com.sonatype.nexus.migration.repository.RepositoryMigrationManager;
import com.sonatype.nexus.migration.ui.RepositoryComponent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.manager.RepositoryManager;

public class ReadRepositoryClient
extends ComponentSupport {
    private static final String REMOTE_UNSUPPORTED = "Remote unsupported.";
    private static final String REPOSITORY_ALREADY_EXISTS = "Repository already exists.";
    private static final String UNSUPPORTED_REPOSITORY = "Unsupported repository.";
    private static final String ALL_MEMBERS_UNSUPPORTED = "All members of group repository are unsupported.";
    private final RepositoryClient client;
    private final MigrationAssistant assistant;
    private final RepositoryManager repositoryManager;
    private final RepositoryMigrationManager repositoryMigrationManager;
    private final Map<String, RepositoryClient.RepositoryDetailXO> cache = new HashMap<String, RepositoryClient.RepositoryDetailXO>();

    public ReadRepositoryClient(RepositoryClient client, MigrationAssistant assistant, RepositoryManager repositoryManager, RepositoryMigrationManager repositoryMigrationManager) {
        this.client = client;
        this.assistant = assistant;
        this.repositoryManager = repositoryManager;
        this.repositoryMigrationManager = repositoryMigrationManager;
    }

    public List<RepositoryComponent.RepositoryXO> read() {
        this.log.debug("Retrieving repositories from NXRM2");
        Iterable<RepositoryClient.RepositorySummaryXO> repos = this.client.get(this.assistant);
        return StreamSupport.stream(repos.spliterator(), false).map(repo -> {
            this.log.trace("Calculating summary for repository {}", (Object)repo.getId());
            boolean supported = true;
            String status = "Ready";
            if (repo.isSupported()) {
                if (!this.repositoryMigrationManager.isSupported(repo.getFormat(), repo.getType(), repo.getMemberRepositoryIds())) {
                    supported = false;
                    status = UNSUPPORTED_REPOSITORY;
                } else if (ReadRepositoryClient.isGroup(repo.getType()) && this.allUnsupported(this.flattenedMembersSupport(repo.getMemberRepositoryIds()))) {
                    supported = false;
                    status = ALL_MEMBERS_UNSUPPORTED;
                } else if (this.repositoryManager.exists(repo.getId())) {
                    supported = false;
                    status = REPOSITORY_ALREADY_EXISTS;
                }
            } else {
                supported = false;
                String string = status = repo.getUnsupportedReason() != null ? repo.getUnsupportedReason() : REMOTE_UNSUPPORTED;
            }
            if (!supported) {
                this.log.trace("Unsupported repository: {} '{}'", (Object)repo.getId(), (Object)status);
            }
            return new RepositoryComponent.RepositoryXO(repo.getName(), repo.getId(), repo.getType(), repo.getFormat(), supported, status);
        }).collect(Collectors.toList());
    }

    private RepositoryClient.RepositoryDetailXO get(String repositoryId) {
        if (this.cache.containsKey(repositoryId)) {
            this.log.trace("Cached hit for {}", (Object)repositoryId);
            return this.cache.get(repositoryId);
        }
        this.log.trace("Cache miss for {}", (Object)repositoryId);
        RepositoryClient.RepositoryDetailXO detail = this.client.get(this.assistant, repositoryId);
        this.cache.put(repositoryId, detail);
        return detail;
    }

    private boolean allUnsupported(List<Boolean> groupMemberSupport) {
        return StreamSupport.stream(groupMemberSupport.spliterator(), false).allMatch(e -> e == false);
    }

    private List<Boolean> flattenedMembersSupport(List<String> memberIds) {
        return StreamSupport.stream(memberIds.spliterator(), false).map(memberId -> {
            RepositoryClient.RepositoryDetailXO detail = this.get((String)memberId);
            if (ReadRepositoryClient.isGroup(detail.getType())) {
                return !this.allUnsupported(this.flattenedMembersSupport(this.getMembers((String)memberId)));
            }
            return this.memberSupported((String)memberId);
        }).collect(Collectors.toList());
    }

    private List<String> getMembers(String memberId) {
        RepositoryClient.RepositoryDetailXO detail = this.get(memberId);
        if (ReadRepositoryClient.isGroup(detail.getType()) && detail.getAttributes() != null) {
            return (List)detail.getAttributes().get("memberNames");
        }
        return Collections.emptyList();
    }

    private boolean memberSupported(String memberId) {
        RepositoryClient.RepositoryDetailXO detail = this.get(memberId);
        return detail.getSupported();
    }

    private static boolean isGroup(String type) {
        return "group".equals(type);
    }
}

