/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.client.http;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.migration.client.http.ClientRequestMonitor;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;
import org.sonatype.goodies.common.ComponentSupport;

@Named(value="migration")
@Singleton
public class MonitoredHttpRetryHandler
extends ComponentSupport
implements HttpRequestRetryHandler {
    private final ClientRequestMonitor monitor;

    @Inject
    public MonitoredHttpRetryHandler(ClientRequestMonitor monitor) {
        this.monitor = (ClientRequestMonitor)Preconditions.checkNotNull((Object)monitor);
    }

    public boolean retryRequest(IOException e, int executionCount, HttpContext context) {
        this.log.warn("Considering HTTP retry after {} failures, most recent: {}", (Object)executionCount, (Object)e.getMessage());
        this.monitor.requestFailed(e.getMessage());
        this.monitor.maybeDelayRequest();
        if (this.monitor.isIndefiniteRetry()) {
            return true;
        }
        return executionCount < 3;
    }
}

