/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.client.http;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.migration.client.http.ClientRequestMonitor;
import com.sonatype.nexus.migration.client.http.MonitoredHttpClient;
import com.sonatype.nexus.migration.client.http.MonitoredHttpRetryHandler;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.sonatype.nexus.httpclient.HttpClientManager;

@Named(value="migration")
public class MonitoredHttpClientFactory
implements Provider<HttpClient> {
    private final HttpClientManager httpClientManager;
    private final MonitoredHttpRetryHandler retryHandler;
    private final ClientRequestMonitor clientRequestMonitor;

    @Inject
    public MonitoredHttpClientFactory(HttpClientManager httpClientManager, @Named(value="migration") @Named(value="migration") MonitoredHttpRetryHandler retryHandler, ClientRequestMonitor clientRequestMonitor) {
        this.httpClientManager = (HttpClientManager)Preconditions.checkNotNull((Object)httpClientManager);
        this.retryHandler = (MonitoredHttpRetryHandler)((Object)Preconditions.checkNotNull((Object)((Object)retryHandler)));
        this.clientRequestMonitor = (ClientRequestMonitor)Preconditions.checkNotNull((Object)clientRequestMonitor);
    }

    public HttpClient get() {
        CloseableHttpClient client = this.httpClientManager.create(plan -> {
            HttpClientBuilder httpClientBuilder = plan.getClient().setRetryHandler((HttpRequestRetryHandler)this.retryHandler);
        });
        return new MonitoredHttpClient(client, this.clientRequestMonitor);
    }
}

