/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.client.http;

import com.google.common.base.Preconditions;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.client.Client;
import org.apache.http.client.HttpClient;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rest.client.RestClientConfiguration;
import org.sonatype.nexus.rest.client.RestClientFactory;

@Named(value="migration")
@Singleton
public class MigrationResteasyClientFactory
extends ComponentSupport
implements RestClientFactory {
    private final Provider<HttpClient> httpClient;
    private final RestClientFactory defaultRestClientFactory;

    @Inject
    public MigrationResteasyClientFactory(@Named(value="migration") @Named(value="migration") Provider<HttpClient> httpClient, RestClientFactory defaultRestClientFactory) {
        this.httpClient = (Provider)Preconditions.checkNotNull(httpClient);
        this.defaultRestClientFactory = (RestClientFactory)Preconditions.checkNotNull((Object)defaultRestClientFactory);
    }

    public Client create(RestClientConfiguration configuration) {
        Preconditions.checkArgument((configuration.getHttpClient() == null ? 1 : 0) != 0);
        return this.defaultRestClientFactory.create(configuration.withHttpClient(() -> this.httpClient.get()));
    }

    public <T> T proxy(Class<T> api, Client client, URI baseUri) {
        return (T)this.defaultRestClientFactory.proxy(api, client, baseUri);
    }
}

