/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.audit.internal;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditDataRecordedEvent;
import org.sonatype.nexus.webhooks.GlobalWebhook;
import org.sonatype.nexus.webhooks.WebhookPayload;
import org.sonatype.nexus.webhooks.WebhookSubscription;

@Named
@Singleton
public class GlobalAuditWebhook
extends GlobalWebhook {
    public static final String NAME = "audit";

    public String getName() {
        return NAME;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(AuditDataRecordedEvent event) {
        AuditData auditData = event.getData();
        AuditWebhookPayload payload = new AuditWebhookPayload();
        payload.setInitiator(auditData.getInitiator());
        payload.setNodeId(auditData.getNodeId());
        AuditWebhookPayload.Audit audit = new AuditWebhookPayload.Audit(auditData.getDomain(), auditData.getType(), auditData.getContext(), auditData.getAttributes());
        payload.setAudit(audit);
        this.getSubscriptions().forEach(s -> this.queue((WebhookSubscription)s, payload));
    }

    public static class AuditWebhookPayload
    extends WebhookPayload {
        private Audit audit;

        public Audit getAudit() {
            return this.audit;
        }

        public void setAudit(Audit audit) {
            this.audit = audit;
        }

        public static class Audit {
            private String domain;
            private String type;
            private String context;
            private Map<String, Object> attributes;

            public Audit(String domain, String type, String context, Map<String, Object> attributes) {
                this.domain = domain;
                this.type = type;
                this.context = context;
                this.attributes = attributes;
            }

            public String getDomain() {
                return this.domain;
            }

            public void setDomain(String domain) {
                this.domain = domain;
            }

            public String getType() {
                return this.type;
            }

            public void setType(String type) {
                this.type = type;
            }

            public String getContext() {
                return this.context;
            }

            public void setContext(String context) {
                this.context = context;
            }

            public Map<String, Object> getAttributes() {
                return this.attributes;
            }

            public void setAttributes(Map<String, Object> attributes) {
                this.attributes = attributes;
            }
        }
    }
}

