/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.audit.internal;

import com.google.common.base.Preconditions;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditDataRecordedEvent;
import org.sonatype.nexus.audit.AuditRecorder;
import org.sonatype.nexus.audit.InitiatorProvider;
import org.sonatype.nexus.audit.internal.AuditDTO;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;

@Named
@Singleton
public class AuditRecorderImpl
extends ComponentSupport
implements AuditRecorder {
    private final EventManager eventManager;
    private final NodeAccess nodeAccess;
    private final InitiatorProvider initiatorProvider;
    private final Logger auditLogger = LoggerFactory.getLogger((String)"auditlog");
    private volatile boolean enabled = false;

    @Inject
    public AuditRecorderImpl(EventManager eventManager, NodeAccess nodeAccess, InitiatorProvider initiatorProvider) {
        this.eventManager = eventManager;
        this.nodeAccess = nodeAccess;
        this.initiatorProvider = initiatorProvider;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void record(AuditData data) {
        Preconditions.checkNotNull((Object)data);
        if (this.enabled) {
            if (data.getTimestamp() == null) {
                data.setTimestamp(new Date());
            }
            if (data.getNodeId() == null) {
                data.setNodeId(this.nodeAccess.getId());
            }
            if (data.getInitiator() == null) {
                String initiator = this.initiatorProvider.get();
                if (initiator.contains("*UNKNOWN")) {
                    this.setInitiator(data, initiator);
                } else {
                    data.setInitiator(initiator);
                }
            }
            try {
                this.auditLogger.info(TaskLoggingMarkers.AUDIT_LOG_ONLY, new AuditDTO(data).toString());
                this.eventManager.post((Object)new AuditDataRecordedEvent(data));
            }
            catch (Exception e) {
                this.log.warn("Failed to record audit data", (Throwable)e);
            }
        }
    }

    private void setInitiator(AuditData data, String initiator) {
        if (data.getAttributes().containsKey("principal")) {
            String newInitiator = initiator.replace("*UNKNOWN", data.getAttributes().get("principal").toString());
            data.setInitiator(newInitiator);
        } else {
            data.setInitiator(initiator);
        }
    }
}

