/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.audit.internal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.sonatype.nexus.audit.AuditData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AuditDTO {
    private String timestamp;
    private String nodeId;
    private String initiator;
    private String domain;
    private String type;
    private String context;
    private String thread;
    private Map<String, Object> attributes;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSSZ");
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule());

    public AuditDTO() {
    }

    public AuditDTO(AuditData auditData) {
        if (auditData.getTimestamp() != null) {
            this.timestamp = auditData.getTimestamp().toInstant().atZone(ZoneId.systemDefault()).toOffsetDateTime().format(DATE_FORMAT);
        }
        this.nodeId = auditData.getNodeId();
        this.initiator = auditData.getInitiator();
        this.domain = auditData.getDomain();
        this.type = auditData.getType();
        this.context = auditData.getContext();
        this.thread = Thread.currentThread().getName();
        this.attributes = auditData.getAttributes();
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public void setInitiator(String initiator) {
        this.initiator = initiator;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getThread() {
        return this.thread;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public String toString() {
        return OBJECT_MAPPER.valueToTree((Object)this).toString();
    }
}

