/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.audit.internal;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.audit.AuditRecorder;
import org.sonatype.nexus.audit.internal.AuditRecorderImpl;
import org.sonatype.nexus.capability.CapabilityConfigurationSupport;
import org.sonatype.nexus.capability.CapabilityDescriptorSupport;
import org.sonatype.nexus.capability.CapabilitySupport;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.capability.Tag;
import org.sonatype.nexus.capability.Taggable;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.formfields.FormField;

@Named(value="audit")
public class AuditCapability
extends CapabilitySupport<Configuration> {
    public static final String TYPE_ID = "audit";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"audit");
    static final Messages messages = (Messages)I18N.create(Messages.class);
    private final AuditRecorder auditRecorder;

    @Inject
    public AuditCapability(AuditRecorder auditRecorder) {
        this.auditRecorder = (AuditRecorder)Preconditions.checkNotNull((Object)auditRecorder);
    }

    protected Configuration createConfig(Map<String, String> properties) {
        return new Configuration(properties);
    }

    @Nullable
    protected String renderDescription() {
        if (this.context().isActive()) {
            return messages.enabled();
        }
        return messages.disabled();
    }

    public Condition activationCondition() {
        return this.conditions().capabilities().passivateCapabilityDuringUpdate();
    }

    protected void onActivate(Configuration config) {
        if (this.auditRecorder instanceof AuditRecorderImpl) {
            ((AuditRecorderImpl)this.auditRecorder).setEnabled(true);
        }
    }

    protected void onPassivate(Configuration config) {
        if (this.auditRecorder instanceof AuditRecorderImpl) {
            ((AuditRecorderImpl)this.auditRecorder).setEnabled(false);
        }
    }

    public static class Configuration
    extends CapabilityConfigurationSupport {
        public Configuration(Map<String, String> properties) {
        }
    }

    @AvailabilityVersion(from="1.0")
    @Named(value="audit")
    @Singleton
    public static class Descriptor
    extends CapabilityDescriptorSupport<Configuration>
    implements Taggable {
        public Descriptor() {
            this.setExposed(true);
            this.setHidden(false);
        }

        public CapabilityType type() {
            return TYPE;
        }

        public String name() {
            return messages.name();
        }

        public List<FormField> formFields() {
            return Collections.emptyList();
        }

        protected Configuration createConfig(Map<String, String> properties) {
            return new Configuration(properties);
        }

        protected String renderAbout() {
            return this.render("audit-about.vm");
        }

        public Set<Tag> getTags() {
            return Collections.singleton(Tag.categoryTag((String)messages.category()));
        }
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Audit")
        public String name();

        @MessageBundle.DefaultMessage(value="Audit")
        public String category();

        @MessageBundle.DefaultMessage(value="Disabled")
        public String disabled();

        @MessageBundle.DefaultMessage(value="Enabled")
        public String enabled();
    }
}

