/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.validation.internal;

import com.thoughtworks.paranamer.Paranamer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import org.hibernate.validator.parameternameprovider.ParanamerParameterNameProvider;

public class AopAwareParanamerParameterNameProvider
extends ParanamerParameterNameProvider {
    private static final String GUICE_ENHANCED = "$$EnhancerByGuice$$";

    public AopAwareParanamerParameterNameProvider() {
    }

    public AopAwareParanamerParameterNameProvider(Paranamer paranamer) {
        super(paranamer);
    }

    private static boolean isEnhancedSubclass(Class<?> type) {
        return type.getName().contains(GUICE_ENHANCED);
    }

    public List<String> getParameterNames(Constructor<?> constructor) {
        return super.getParameterNames(this.resolve(constructor));
    }

    private Constructor<?> resolve(Constructor<?> constructor) {
        Class<?> type = constructor.getDeclaringClass();
        if (AopAwareParanamerParameterNameProvider.isEnhancedSubclass(type)) {
            try {
                return type.getSuperclass().getDeclaredConstructor(constructor.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return constructor;
    }

    public List<String> getParameterNames(Method method) {
        return super.getParameterNames(this.resolve(method));
    }

    private Method resolve(Method method) {
        Class<?> type = method.getDeclaringClass();
        if (AopAwareParanamerParameterNameProvider.isEnhancedSubclass(type)) {
            try {
                return type.getSuperclass().getDeclaredMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return method;
    }
}

