/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.validation.constraint;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.validation.ConstraintValidatorSupport;
import org.sonatype.nexus.validation.constraint.Url;

public class UrlValidator
extends ConstraintValidatorSupport<Url, URI> {
    private static final Pattern SCHEME_RE = Pattern.compile("^https?$", 2);
    private static final Pattern USER_INFO_RE = Pattern.compile("^(?:\\S+(?::\\S*)?)?$", 2);
    private static final Pattern RESOURCE_RE = Pattern.compile("^(?:[ \\S]*\\S)?$", 2);
    private static final Pattern HOSTNAME_RE = Pattern.compile("^(?:[^\"<>^`{|}:/]+)$", 2);
    private static final Pattern IPV6_RE = Pattern.compile("^\\[(?<ipv6>[0-9:a-f]{3,39})\\]$", 2);
    private static final InetAddressValidator INET_ADDRESS_VALIDATOR = new InetAddressValidator();

    public boolean isValid(URI uri, ConstraintValidatorContext constraintValidatorContext) {
        if (uri == null) {
            return true;
        }
        try {
            uri.toURL();
            return this.isValidScheme(uri.getScheme()) && this.isValidUserInfo(uri.getUserInfo()) && this.isValidHost(uri.getHost()) && this.isValidPort(uri.getPort()) && this.isValidPath(uri.getPath()) && this.isValidFragment(uri.getFragment());
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            this.log.debug("Failed to parse URL from {} with message {}", (Object)uri, (Object)e.getMessage());
            return false;
        }
    }

    private boolean isMatch(Pattern pattern, String string, boolean allowBlank) {
        return allowBlank && Strings2.isBlank((String)string) || string != null && pattern.matcher(string).find();
    }

    private boolean isMatch(Pattern pattern, String string) {
        return this.isMatch(pattern, string, true);
    }

    private boolean isValidScheme(String scheme) {
        return this.isMatch(SCHEME_RE, scheme);
    }

    private boolean isValidUserInfo(String userInfo) {
        return this.isMatch(USER_INFO_RE, userInfo);
    }

    private boolean isValidHost(String host) {
        return this.isMatch(HOSTNAME_RE, host, false) || this.isMatch(IPV6_RE, host, false) && INET_ADDRESS_VALIDATOR.isValidInet6Address(host.substring(1, host.length() - 2));
    }

    private boolean isValidPort(int port) {
        return port == -1 || port > 0 && port <= 65535;
    }

    private boolean isValidPath(String path) {
        return this.isMatch(RESOURCE_RE, path);
    }

    private boolean isValidFragment(String fragment) {
        return this.isMatch(RESOURCE_RE, fragment);
    }
}

