/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.validation.constraint;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.validation.ConstraintValidatorContext;
import org.sonatype.nexus.validation.ConstraintValidatorSupport;
import org.sonatype.nexus.validation.constraint.AnyOf;

@Named
public class AnyOfValidator
extends ConstraintValidatorSupport<AnyOf, String> {
    Set<String> values;
    String paramName;
    String message;

    @Override
    public void initialize(AnyOf annotation) {
        Class<Enum<?>> enumClass = annotation.enumClass();
        this.paramName = annotation.parameterName();
        this.message = annotation.message();
        this.values = Stream.of(enumClass.getEnumConstants()).map(Enum::name).map(String::toLowerCase).collect(Collectors.toSet());
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        boolean isValid = this.values.contains(value.toLowerCase());
        if (!isValid) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(this.getEscapeHelper().stripJavaEl(this.buildMessage())).addConstraintViolation();
        }
        return isValid;
    }

    private String buildMessage() {
        return String.format(this.message, this.paramName, String.join((CharSequence)",", this.values));
    }
}

