/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.defaultrole.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.plugins.defaultrole.DefaultRoleRealm;
import org.sonatype.nexus.rapture.StateContributor;
import org.sonatype.nexus.security.SecuritySystem;
import org.sonatype.nexus.security.role.Role;

@Named
@Singleton
public class DefaultRoleStateContributor
extends ComponentSupport
implements StateContributor {
    private final DefaultRoleRealm defaultRoleRealm;
    private final SecuritySystem securitySystem;

    @Inject
    public DefaultRoleStateContributor(DefaultRoleRealm defaultRoleRealm, SecuritySystem securitySystem) {
        this.defaultRoleRealm = defaultRoleRealm;
        this.securitySystem = securitySystem;
    }

    public Map<String, Object> getState() {
        Subject subject = SecurityUtils.getSubject();
        if (subject != null && (subject.isAuthenticated() || subject.isRemembered())) {
            try {
                HashMap<String, String> defaultRole = new HashMap<String, String>(2);
                Role matched = this.securitySystem.listRoles("default").stream().filter(role -> role.getRoleId().equals(this.defaultRoleRealm.getRole())).findFirst().orElse(null);
                defaultRole.put("id", matched.getRoleId());
                defaultRole.put("name", matched.getName());
                return Collections.singletonMap("defaultRole", defaultRole);
            }
            catch (Exception e) {
                this.log.debug("Unable to fetch default role configuration", (Throwable)e);
            }
        }
        return Collections.emptyMap();
    }
}

