/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.defaultrole.internal;

import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.capability.CapabilityDescriptorSupport;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.formfields.ComboboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.plugins.defaultrole.internal.DefaultRoleCapabilityConfiguration;

@AvailabilityVersion(from="1.0")
@Named(value="defaultrole")
@Singleton
public class DefaultRoleCapabilityDescriptor
extends CapabilityDescriptorSupport<DefaultRoleCapabilityConfiguration> {
    public static final String TYPE_ID = "defaultrole";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"defaultrole");
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final ComboboxFormField role;

    public DefaultRoleCapabilityDescriptor() {
        this.setExposed(true);
        this.setHidden(false);
        this.role = new ComboboxFormField("role", messages.roleLabel(), messages.roleHelp(), true).withStoreApi("coreui_Role.read");
    }

    public CapabilityType type() {
        return TYPE;
    }

    public String name() {
        return messages.name();
    }

    public List<FormField> formFields() {
        return Collections.singletonList(this.role);
    }

    protected String renderAbout() {
        return this.render("defaultrole-about.vm");
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Default Role")
        public String name();

        @MessageBundle.DefaultMessage(value="Role")
        public String roleLabel();

        @MessageBundle.DefaultMessage(value="The role which is automatically granted to authenticated users")
        public String roleHelp();
    }
}

