/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.defaultrole.internal;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.capability.CapabilitySupport;
import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.plugins.defaultrole.DefaultRoleRealm;
import org.sonatype.nexus.plugins.defaultrole.internal.DefaultRoleCapabilityConfiguration;
import org.sonatype.nexus.security.realm.RealmManager;

@Named(value="defaultrole")
public class DefaultRoleCapability
extends CapabilitySupport<DefaultRoleCapabilityConfiguration> {
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final RealmManager realmManager;
    private final DefaultRoleRealm defaultRoleRealm;

    @Inject
    public DefaultRoleCapability(RealmManager realmManager, DefaultRoleRealm defaultRoleRealm) {
        this.realmManager = (RealmManager)Preconditions.checkNotNull((Object)realmManager);
        this.defaultRoleRealm = (DefaultRoleRealm)((Object)Preconditions.checkNotNull((Object)((Object)defaultRoleRealm)));
    }

    protected DefaultRoleCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new DefaultRoleCapabilityConfiguration(properties);
    }

    protected String renderDescription() {
        return messages.description(this.defaultRoleRealm.getRole());
    }

    public Condition activationCondition() {
        return this.conditions().capabilities().passivateCapabilityDuringUpdate();
    }

    protected void onActivate(DefaultRoleCapabilityConfiguration defaultRoleCapabilityConfiguration) {
        this.defaultRoleRealm.setRole(defaultRoleCapabilityConfiguration.getRole());
        this.realmManager.enableRealm("DefaultRole");
    }

    protected void onPassivate(DefaultRoleCapabilityConfiguration defaultRoleCapabilityConfiguration) {
        this.realmManager.disableRealm("DefaultRole");
        this.defaultRoleRealm.setRole(null);
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="%s")
        public String description(String var1);
    }
}

