/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.defaultrole;

import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.security.anonymous.AnonymousHelper;

@Named(value="DefaultRole")
@Singleton
@Description(value="Default Role Realm")
public class DefaultRoleRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(DefaultRoleRealm.class);
    public static final String NAME = "DefaultRole";
    private String role;

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return this.maybeGrantRole(principals);
    }

    private AuthorizationInfo maybeGrantRole(PrincipalCollection principals) {
        if (this.role != null && !AnonymousHelper.isAnonymous((PrincipalCollection)principals)) {
            SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
            info.addRole(this.role);
            log.debug("Granting {} role to {}", (Object)this.role, (Object)principals);
            return info;
        }
        return null;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public String getRole() {
        return this.role;
    }

    public void setRole(@Nullable String role) {
        this.role = role;
    }
}

