/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.context;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.PrefixAnalyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.search.suggest.context.ContextBuilder;
import org.elasticsearch.search.suggest.context.ContextMapping;

public class CategoryContextMapping
extends ContextMapping {
    protected static final String TYPE = "category";
    private static final String FIELD_FIELDNAME = "path";
    private static final String DEFAULT_FIELDNAME = "_type";
    private static final Iterable<? extends CharSequence> EMPTY_VALUES = Collections.emptyList();
    private final String fieldName;
    private final Iterable<? extends CharSequence> defaultValues;
    private final FieldConfig defaultConfig;

    public CategoryContextMapping(String name) {
        this(name, DEFAULT_FIELDNAME, EMPTY_VALUES);
    }

    public CategoryContextMapping(String name, String fieldName) {
        this(name, fieldName, EMPTY_VALUES);
    }

    public CategoryContextMapping(String name, Iterable<? extends CharSequence> defaultValues) {
        this(name, DEFAULT_FIELDNAME, defaultValues);
    }

    public CategoryContextMapping(String name, String fieldName, Iterable<? extends CharSequence> defaultValues) {
        super(TYPE, name);
        this.fieldName = fieldName;
        this.defaultValues = defaultValues;
        this.defaultConfig = new FieldConfig(fieldName, defaultValues, null);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Iterable<? extends CharSequence> getDefaultValues() {
        return this.defaultValues;
    }

    @Override
    public FieldConfig defaultConfig() {
        return this.defaultConfig;
    }

    protected static CategoryContextMapping load(String name, Map<String, Object> config) throws ElasticsearchParseException {
        Builder mapping = new Builder(name);
        Object fieldName = config.get(FIELD_FIELDNAME);
        Object defaultValues = config.get("default");
        if (fieldName != null) {
            mapping.fieldName(fieldName.toString());
            config.remove(FIELD_FIELDNAME);
        }
        if (defaultValues != null) {
            if (defaultValues instanceof Iterable) {
                for (Object value : (Iterable)defaultValues) {
                    mapping.addDefaultValue(value.toString());
                }
            } else {
                mapping.addDefaultValue(defaultValues.toString());
            }
            config.remove("default");
        }
        return mapping.build();
    }

    @Override
    protected XContentBuilder toInnerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.fieldName != null) {
            builder.field(FIELD_FIELDNAME, this.fieldName);
        }
        builder.startArray("default");
        for (CharSequence charSequence : this.defaultValues) {
            builder.value(charSequence);
        }
        builder.endArray();
        return builder;
    }

    @Override
    public ContextMapping.ContextConfig parseContext(ParseContext parseContext, XContentParser parser) throws IOException, ElasticsearchParseException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_NULL) {
            return new FieldConfig(this.fieldName, this.defaultValues, null);
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            return new FieldConfig(this.fieldName, null, Collections.singleton(parser.text()));
        }
        if (token == XContentParser.Token.VALUE_NUMBER) {
            return new FieldConfig(this.fieldName, null, Collections.singleton(parser.text()));
        }
        if (token == XContentParser.Token.VALUE_BOOLEAN) {
            return new FieldConfig(this.fieldName, null, Collections.singleton(parser.text()));
        }
        if (token == XContentParser.Token.START_ARRAY) {
            ArrayList<String> values = new ArrayList<String>();
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                values.add(parser.text());
            }
            if (values.isEmpty()) {
                throw new ElasticsearchParseException("FieldConfig must contain a least one category", new Object[0]);
            }
            return new FieldConfig(this.fieldName, null, values);
        }
        throw new ElasticsearchParseException("FieldConfig must be either [null], a string or a list of strings", new Object[0]);
    }

    @Override
    public FieldQuery parseQuery(String name, XContentParser parser) throws IOException, ElasticsearchParseException {
        Iterable<? extends CharSequence> values;
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            ArrayList<? extends CharSequence> list = new ArrayList<CharSequence>();
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                list.add(parser.text());
            }
            values = list;
        } else {
            values = token == XContentParser.Token.VALUE_NULL ? this.defaultValues : Collections.singleton(parser.text());
        }
        return new FieldQuery(name, values);
    }

    public static FieldQuery query(String name, CharSequence ... fieldvalues) {
        return CategoryContextMapping.query(name, Arrays.asList(fieldvalues));
    }

    public static FieldQuery query(String name, Iterable<? extends CharSequence> fieldvalues) {
        return new FieldQuery(name, fieldvalues);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CategoryContextMapping) {
            CategoryContextMapping other = (CategoryContextMapping)obj;
            if (this.fieldName.equals(other.fieldName)) {
                return Iterables.elementsEqual(this.defaultValues, other.defaultValues);
            }
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.fieldName.hashCode();
        for (CharSequence charSequence : this.defaultValues) {
            hashCode = 31 * hashCode + charSequence.hashCode();
        }
        return hashCode;
    }

    public static class Builder
    extends ContextBuilder<CategoryContextMapping> {
        private String fieldname;
        private List<CharSequence> defaultValues = new ArrayList<CharSequence>();

        public Builder(String name) {
            this(name, CategoryContextMapping.DEFAULT_FIELDNAME);
        }

        public Builder(String name, String fieldname) {
            super(name);
            this.fieldname = fieldname;
        }

        public Builder fieldName(String fieldname) {
            this.fieldname = fieldname;
            return this;
        }

        public Builder addDefaultValue(CharSequence defaultValue) {
            this.defaultValues.add(defaultValue);
            return this;
        }

        public Builder addDefaultValues(CharSequence ... defaultValues) {
            for (CharSequence defaultValue : defaultValues) {
                this.defaultValues.add(defaultValue);
            }
            return this;
        }

        public Builder addDefaultValues(Iterable<? extends CharSequence> defaultValues) {
            for (CharSequence charSequence : defaultValues) {
                this.defaultValues.add(charSequence);
            }
            return this;
        }

        @Override
        public CategoryContextMapping build() {
            return new CategoryContextMapping(this.name, this.fieldname, this.defaultValues);
        }
    }

    private static class FieldQuery
    extends ContextMapping.ContextQuery {
        private final Iterable<? extends CharSequence> values;

        public FieldQuery(String name, Iterable<? extends CharSequence> values) {
            super(name);
            this.values = values;
        }

        @Override
        public Automaton toAutomaton() {
            ArrayList<Automaton> automatons = new ArrayList<Automaton>();
            for (CharSequence charSequence : this.values) {
                automatons.add(Automata.makeString(charSequence.toString()));
            }
            return Operations.union(automatons);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray(this.name);
            for (CharSequence charSequence : this.values) {
                builder.value(charSequence);
            }
            builder.endArray();
            return builder;
        }
    }

    private static class FieldConfig
    extends ContextMapping.ContextConfig {
        private final String fieldname;
        private final Iterable<? extends CharSequence> defaultValues;
        private final Iterable<? extends CharSequence> values;

        public FieldConfig(String fieldname, Iterable<? extends CharSequence> defaultValues, Iterable<? extends CharSequence> values) {
            this.fieldname = fieldname;
            this.defaultValues = defaultValues;
            this.values = values;
        }

        @Override
        protected TokenStream wrapTokenStream(ParseContext.Document doc, TokenStream stream) {
            if (this.values != null) {
                return new PrefixAnalyzer.PrefixTokenFilter(stream, '\u001d', this.values);
            }
            if ((doc.getFields(this.fieldname).length == 0 || this.fieldname.equals(CategoryContextMapping.DEFAULT_FIELDNAME)) && this.defaultValues.iterator().hasNext()) {
                return new PrefixAnalyzer.PrefixTokenFilter(stream, '\u001d', this.defaultValues);
            }
            IndexableField[] fields = doc.getFields(this.fieldname);
            ArrayList<String> values = new ArrayList<String>(fields.length);
            for (int i = 0; i < fields.length; ++i) {
                values.add(fields[i].stringValue());
            }
            return new PrefixAnalyzer.PrefixTokenFilter(stream, '\u001d', values);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("FieldConfig(" + this.fieldname + " = [");
            if (this.values != null && this.values.iterator().hasNext()) {
                sb.append("(").append(Joiner.on((String)", ").join(this.values.iterator())).append(")");
            }
            if (this.defaultValues != null && this.defaultValues.iterator().hasNext()) {
                sb.append(" default(").append(Joiner.on((String)", ").join(this.defaultValues.iterator())).append(")");
            }
            return sb.append("])").toString();
        }
    }
}

