/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.fielddata.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardUtils;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCacheListener;
import org.elasticsearch.threadpool.ThreadPool;

public class IndicesFieldDataCache
extends AbstractComponent
implements RemovalListener<Key, Accountable> {
    public static final String FIELDDATA_CLEAN_INTERVAL_SETTING = "indices.fielddata.cache.cleanup_interval";
    public static final String FIELDDATA_CACHE_CONCURRENCY_LEVEL = "indices.fielddata.cache.concurrency_level";
    public static final String INDICES_FIELDDATA_CACHE_SIZE_KEY = "indices.fielddata.cache.size";
    private final IndicesFieldDataCacheListener indicesFieldDataCacheListener;
    private final Cache<Key, Accountable> cache;
    private final TimeValue cleanInterval;
    private final ThreadPool threadPool;
    private volatile boolean closed = false;

    @Inject
    public IndicesFieldDataCache(Settings settings, IndicesFieldDataCacheListener indicesFieldDataCacheListener, ThreadPool threadPool) {
        super(settings);
        int concurrencyLevel;
        this.threadPool = threadPool;
        this.indicesFieldDataCacheListener = indicesFieldDataCacheListener;
        String size = settings.get(INDICES_FIELDDATA_CACHE_SIZE_KEY, "-1");
        long sizeInBytes = settings.getAsMemory(INDICES_FIELDDATA_CACHE_SIZE_KEY, "-1").bytes();
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().removalListener((RemovalListener)this);
        if (sizeInBytes > 0L) {
            cacheBuilder.maximumWeight(sizeInBytes).weigher((Weigher)new FieldDataWeigher());
        }
        if ((concurrencyLevel = settings.getAsInt(FIELDDATA_CACHE_CONCURRENCY_LEVEL, (Integer)16).intValue()) <= 0) {
            throw new IllegalArgumentException("concurrency_level must be > 0 but was: " + concurrencyLevel);
        }
        cacheBuilder.concurrencyLevel(concurrencyLevel);
        this.logger.debug("using size [{}] [{}]", size, new ByteSizeValue(sizeInBytes));
        this.cache = cacheBuilder.build();
        this.cleanInterval = settings.getAsTime(FIELDDATA_CLEAN_INTERVAL_SETTING, TimeValue.timeValueMinutes(1L));
        threadPool.schedule(this.cleanInterval, "same", new FieldDataCacheCleaner(this.cache, this.logger, this.threadPool, this.cleanInterval));
    }

    public void close() {
        this.cache.invalidateAll();
        this.closed = true;
    }

    public IndexFieldDataCache buildIndexFieldDataCache(IndexFieldDataCache.Listener listener, Index index, MappedFieldType.Names fieldNames, FieldDataType fieldDataType) {
        return new IndexFieldCache(this.logger, this.cache, index, fieldNames, fieldDataType, this.indicesFieldDataCacheListener, listener);
    }

    public Cache<Key, Accountable> getCache() {
        return this.cache;
    }

    public void onRemoval(RemovalNotification<Key, Accountable> notification) {
        Key key = (Key)notification.getKey();
        assert (key != null && key.listeners != null);
        IndexFieldCache indexCache = key.indexCache;
        Accountable value = (Accountable)notification.getValue();
        for (IndexFieldDataCache.Listener listener : key.listeners) {
            try {
                listener.onRemoval(key.shardId, indexCache.fieldNames, indexCache.fieldDataType, notification.wasEvicted(), value.ramBytesUsed());
            }
            catch (Throwable e) {
                this.logger.error("Failed to call listener on field data cache unloading", e, new Object[0]);
            }
        }
    }

    public class FieldDataCacheCleaner
    implements Runnable {
        private final Cache<Key, Accountable> cache;
        private final ESLogger logger;
        private final ThreadPool threadPool;
        private final TimeValue interval;

        public FieldDataCacheCleaner(Cache cache, ESLogger logger, ThreadPool threadPool, TimeValue interval) {
            this.cache = cache;
            this.logger = logger;
            this.threadPool = threadPool;
            this.interval = interval;
        }

        @Override
        public void run() {
            long startTimeNS = System.nanoTime();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("running periodic field data cache cleanup", new Object[0]);
            }
            try {
                this.cache.cleanUp();
            }
            catch (Exception e) {
                this.logger.warn("Exception during periodic field data cache cleanup:", e, new Object[0]);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("periodic field data cache cleanup finished in {} milliseconds", TimeValue.nsecToMSec(System.nanoTime() - startTimeNS));
            }
            if (!IndicesFieldDataCache.this.closed) {
                this.threadPool.schedule(this.interval, "same", this);
            }
        }
    }

    public static class Key {
        public final IndexFieldCache indexCache;
        public final Object readerKey;
        public final ShardId shardId;
        public final List<IndexFieldDataCache.Listener> listeners = new ArrayList<IndexFieldDataCache.Listener>();

        Key(IndexFieldCache indexCache, Object readerKey, @Nullable ShardId shardId) {
            this.indexCache = indexCache;
            this.readerKey = readerKey;
            this.shardId = shardId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            Key key = (Key)o;
            if (!this.indexCache.equals(key.indexCache)) {
                return false;
            }
            return this.readerKey.equals(key.readerKey);
        }

        public int hashCode() {
            int result = this.indexCache.hashCode();
            result = 31 * result + this.readerKey.hashCode();
            return result;
        }
    }

    static class IndexFieldCache
    implements IndexFieldDataCache,
    LeafReader.CoreClosedListener,
    IndexReader.ReaderClosedListener {
        private final ESLogger logger;
        final Index index;
        final MappedFieldType.Names fieldNames;
        final FieldDataType fieldDataType;
        private final Cache<Key, Accountable> cache;
        private final IndexFieldDataCache.Listener[] listeners;

        IndexFieldCache(ESLogger logger, Cache<Key, Accountable> cache, Index index, MappedFieldType.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache.Listener ... listeners) {
            this.logger = logger;
            this.listeners = listeners;
            this.index = index;
            this.fieldNames = fieldNames;
            this.fieldDataType = fieldDataType;
            this.cache = cache;
        }

        @Override
        public <FD extends AtomicFieldData, IFD extends IndexFieldData<FD>> FD load(final LeafReaderContext context, final IFD indexFieldData) throws Exception {
            final ShardId shardId = ShardUtils.extractShardId(context.reader());
            final Key key = new Key(this, context.reader().getCoreCacheKey(), shardId);
            Accountable accountable = (Accountable)this.cache.get((Object)key, (Callable)new Callable<AtomicFieldData>(){

                @Override
                public AtomicFieldData call() throws Exception {
                    context.reader().addCoreClosedListener(IndexFieldCache.this);
                    for (IndexFieldDataCache.Listener listener : IndexFieldCache.this.listeners) {
                        key.listeners.add(listener);
                    }
                    Object fieldData = indexFieldData.loadDirect(context);
                    for (IndexFieldDataCache.Listener listener : key.listeners) {
                        try {
                            listener.onCache(shardId, IndexFieldCache.this.fieldNames, IndexFieldCache.this.fieldDataType, (Accountable)fieldData);
                        }
                        catch (Throwable e) {
                            IndexFieldCache.this.logger.error("Failed to call listener on atomic field data loading", e, new Object[0]);
                        }
                    }
                    return fieldData;
                }
            });
            return (FD)((AtomicFieldData)accountable);
        }

        @Override
        public <FD extends AtomicFieldData, IFD extends IndexFieldData.Global<FD>> IFD load(final DirectoryReader indexReader, final IFD indexFieldData) throws Exception {
            final ShardId shardId = ShardUtils.extractShardId(indexReader);
            final Key key = new Key(this, indexReader.getCoreCacheKey(), shardId);
            Accountable accountable = (Accountable)this.cache.get((Object)key, (Callable)new Callable<Accountable>(){

                @Override
                public Accountable call() throws Exception {
                    ElasticsearchDirectoryReader.addReaderCloseListener(indexReader, IndexFieldCache.this);
                    for (IndexFieldDataCache.Listener listener : IndexFieldCache.this.listeners) {
                        key.listeners.add(listener);
                    }
                    Accountable ifd = (Accountable)((Object)indexFieldData.localGlobalDirect(indexReader));
                    for (IndexFieldDataCache.Listener listener : key.listeners) {
                        try {
                            listener.onCache(shardId, IndexFieldCache.this.fieldNames, IndexFieldCache.this.fieldDataType, ifd);
                        }
                        catch (Throwable e) {
                            IndexFieldCache.this.logger.error("Failed to call listener on global ordinals loading", e, new Object[0]);
                        }
                    }
                    return ifd;
                }
            });
            return (IFD)((IndexFieldData.Global)((Object)accountable));
        }

        @Override
        public void onClose(Object coreKey) {
            this.cache.invalidate((Object)new Key(this, coreKey, null));
        }

        @Override
        public void onClose(IndexReader reader) {
            this.cache.invalidate((Object)new Key(this, reader.getCoreCacheKey(), null));
        }

        @Override
        public void clear() {
            for (Key key : this.cache.asMap().keySet()) {
                if (!key.indexCache.index.equals(this.index)) continue;
                this.cache.invalidate((Object)key);
            }
            this.cache.cleanUp();
        }

        @Override
        public void clear(String fieldName) {
            for (Key key : this.cache.asMap().keySet()) {
                if (!key.indexCache.index.equals(this.index) || !key.indexCache.fieldNames.fullName().equals(fieldName)) continue;
                this.cache.invalidate((Object)key);
            }
            this.cache.cleanUp();
        }
    }

    public static class FieldDataWeigher
    implements Weigher<Key, Accountable> {
        public int weigh(Key key, Accountable ramUsage) {
            int weight = (int)Math.min(ramUsage.ramBytesUsed(), Integer.MAX_VALUE);
            return weight == 0 ? 1 : weight;
        }
    }
}

