/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.snapshots.blobstore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.FromXContentBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.store.StoreFileMetaData;

public class BlobStoreIndexShardSnapshot
implements ToXContent,
FromXContentBuilder<BlobStoreIndexShardSnapshot> {
    public static final BlobStoreIndexShardSnapshot PROTO = new BlobStoreIndexShardSnapshot();
    private final String snapshot;
    private final long indexVersion;
    private final long startTime;
    private final long time;
    private final int numberOfFiles;
    private final long totalSize;
    private final List<FileInfo> indexFiles;

    public BlobStoreIndexShardSnapshot(String snapshot, long indexVersion, List<FileInfo> indexFiles, long startTime, long time, int numberOfFiles, long totalSize) {
        assert (snapshot != null);
        assert (indexVersion >= 0L);
        this.snapshot = snapshot;
        this.indexVersion = indexVersion;
        this.indexFiles = Collections.unmodifiableList(new ArrayList<FileInfo>(indexFiles));
        this.startTime = startTime;
        this.time = time;
        this.numberOfFiles = numberOfFiles;
        this.totalSize = totalSize;
    }

    private BlobStoreIndexShardSnapshot() {
        this.snapshot = "";
        this.indexVersion = 0L;
        this.indexFiles = Collections.emptyList();
        this.startTime = 0L;
        this.time = 0L;
        this.numberOfFiles = 0;
        this.totalSize = 0L;
    }

    public long indexVersion() {
        return this.indexVersion;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public List<FileInfo> indexFiles() {
        return this.indexFiles;
    }

    public long startTime() {
        return this.startTime;
    }

    public long time() {
        return this.time;
    }

    public int numberOfFiles() {
        return this.numberOfFiles;
    }

    public long totalSize() {
        return this.totalSize;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Fields.NAME, this.snapshot);
        builder.field(Fields.INDEX_VERSION, this.indexVersion);
        builder.field(Fields.START_TIME, this.startTime);
        builder.field(Fields.TIME, this.time);
        builder.field(Fields.NUMBER_OF_FILES, this.numberOfFiles);
        builder.field(Fields.TOTAL_SIZE, this.totalSize);
        builder.startArray(Fields.FILES);
        for (FileInfo fileInfo : this.indexFiles) {
            FileInfo.toXContent(fileInfo, builder, params);
        }
        builder.endArray();
        return builder;
    }

    @Override
    public BlobStoreIndexShardSnapshot fromXContent(XContentParser parser, ParseFieldMatcher parseFieldMatcher) throws IOException {
        XContentParser.Token token;
        String snapshot = null;
        long indexVersion = -1L;
        long startTime = 0L;
        long time = 0L;
        int numberOfFiles = 0;
        long totalSize = 0L;
        ArrayList<FileInfo> indexFiles = new ArrayList<FileInfo>();
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        if ((token = parser.currentToken()) == XContentParser.Token.START_OBJECT) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String currentFieldName = parser.currentName();
                    token = parser.nextToken();
                    if (token.isValue()) {
                        if (parseFieldMatcher.match(currentFieldName, ParseFields.NAME)) {
                            snapshot = parser.text();
                            continue;
                        }
                        if (parseFieldMatcher.match(currentFieldName, ParseFields.INDEX_VERSION)) {
                            indexVersion = parser.longValue();
                            continue;
                        }
                        if (parseFieldMatcher.match(currentFieldName, ParseFields.START_TIME)) {
                            startTime = parser.longValue();
                            continue;
                        }
                        if (parseFieldMatcher.match(currentFieldName, ParseFields.TIME)) {
                            time = parser.longValue();
                            continue;
                        }
                        if (parseFieldMatcher.match(currentFieldName, ParseFields.NUMBER_OF_FILES)) {
                            numberOfFiles = parser.intValue();
                            continue;
                        }
                        if (parseFieldMatcher.match(currentFieldName, ParseFields.TOTAL_SIZE)) {
                            totalSize = parser.longValue();
                            continue;
                        }
                        throw new ElasticsearchParseException("unknown parameter [{}]", currentFieldName);
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        if (parseFieldMatcher.match(currentFieldName, ParseFields.FILES)) {
                            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                indexFiles.add(FileInfo.fromXContent(parser));
                            }
                            continue;
                        }
                        throw new ElasticsearchParseException("unknown parameter [{}]", currentFieldName);
                    }
                    throw new ElasticsearchParseException("unexpected token  [{}]", new Object[]{token});
                }
                throw new ElasticsearchParseException("unexpected token [{}]", new Object[]{token});
            }
        }
        return new BlobStoreIndexShardSnapshot(snapshot, indexVersion, Collections.unmodifiableList(indexFiles), startTime, time, numberOfFiles, totalSize);
    }

    static final class ParseFields {
        static final ParseField NAME = new ParseField("name", new String[0]);
        static final ParseField INDEX_VERSION = new ParseField("index_version", "index-version");
        static final ParseField START_TIME = new ParseField("start_time", new String[0]);
        static final ParseField TIME = new ParseField("time", new String[0]);
        static final ParseField NUMBER_OF_FILES = new ParseField("number_of_files", new String[0]);
        static final ParseField TOTAL_SIZE = new ParseField("total_size", new String[0]);
        static final ParseField FILES = new ParseField("files", new String[0]);

        ParseFields() {
        }
    }

    static final class Fields {
        static final XContentBuilderString NAME = new XContentBuilderString("name");
        static final XContentBuilderString INDEX_VERSION = new XContentBuilderString("index_version");
        static final XContentBuilderString START_TIME = new XContentBuilderString("start_time");
        static final XContentBuilderString TIME = new XContentBuilderString("time");
        static final XContentBuilderString NUMBER_OF_FILES = new XContentBuilderString("number_of_files");
        static final XContentBuilderString TOTAL_SIZE = new XContentBuilderString("total_size");
        static final XContentBuilderString FILES = new XContentBuilderString("files");

        Fields() {
        }
    }

    public static class FileInfo {
        private final String name;
        private final ByteSizeValue partSize;
        private final long partBytes;
        private final long numberOfParts;
        private final StoreFileMetaData metadata;

        public FileInfo(String name, StoreFileMetaData metaData, ByteSizeValue partSize) {
            this.name = name;
            this.metadata = metaData;
            long partBytes = Long.MAX_VALUE;
            if (partSize != null) {
                partBytes = partSize.bytes();
            }
            long totalLength = metaData.length();
            long numberOfParts = totalLength / partBytes;
            if (totalLength % partBytes > 0L) {
                ++numberOfParts;
            }
            if (numberOfParts == 0L) {
                ++numberOfParts;
            }
            this.numberOfParts = numberOfParts;
            this.partSize = partSize;
            this.partBytes = partBytes;
        }

        public String name() {
            return this.name;
        }

        public String partName(long part) {
            if (this.numberOfParts > 1L) {
                return this.name + ".part" + part;
            }
            return this.name;
        }

        public static String canonicalName(String blobName) {
            if (blobName.contains(".part")) {
                return blobName.substring(0, blobName.indexOf(".part"));
            }
            return blobName;
        }

        public String physicalName() {
            return this.metadata.name();
        }

        public long length() {
            return this.metadata.length();
        }

        public ByteSizeValue partSize() {
            return this.partSize;
        }

        public long partBytes(int part) {
            if (this.numberOfParts == 1L) {
                return this.length();
            }
            if ((long)part < this.numberOfParts - 1L) {
                return this.partBytes;
            }
            return this.length() - this.partBytes * (this.numberOfParts - 1L);
        }

        public long numberOfParts() {
            return this.numberOfParts;
        }

        @Nullable
        public String checksum() {
            return this.metadata.checksum();
        }

        public StoreFileMetaData metadata() {
            return this.metadata;
        }

        public boolean isSame(StoreFileMetaData md) {
            return this.metadata.isSame(md);
        }

        public boolean isSame(FileInfo fileInfo) {
            if (this.numberOfParts != fileInfo.numberOfParts) {
                return false;
            }
            if (this.partBytes != fileInfo.partBytes) {
                return false;
            }
            if (!this.name.equals(fileInfo.name)) {
                return false;
            }
            if (this.partSize != null ? !this.partSize.equals(fileInfo.partSize) : fileInfo.partSize != null) {
                return false;
            }
            return this.metadata.isSame(fileInfo.metadata);
        }

        public static void toXContent(FileInfo file, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Fields.NAME, file.name);
            builder.field(Fields.PHYSICAL_NAME, file.metadata.name());
            builder.field(Fields.LENGTH, file.metadata.length());
            if (file.metadata.checksum() != null) {
                builder.field(Fields.CHECKSUM, file.metadata.checksum());
            }
            if (file.partSize != null) {
                builder.field(Fields.PART_SIZE, file.partSize.bytes());
            }
            if (file.metadata.writtenBy() != null) {
                builder.field(Fields.WRITTEN_BY, (Object)file.metadata.writtenBy());
            }
            if (file.metadata.hash() != null && file.metadata().hash().length > 0) {
                builder.field(Fields.META_HASH, file.metadata.hash());
            }
            builder.endObject();
        }

        public static FileInfo fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            String name = null;
            String physicalName = null;
            long length = -1L;
            String checksum = null;
            ByteSizeValue partSize = null;
            Version writtenBy = null;
            BytesRef metaHash = new BytesRef();
            if (token == XContentParser.Token.START_OBJECT) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        String currentFieldName = parser.currentName();
                        token = parser.nextToken();
                        if (token.isValue()) {
                            if ("name".equals(currentFieldName)) {
                                name = parser.text();
                                continue;
                            }
                            if ("physical_name".equals(currentFieldName)) {
                                physicalName = parser.text();
                                continue;
                            }
                            if ("length".equals(currentFieldName)) {
                                length = parser.longValue();
                                continue;
                            }
                            if ("checksum".equals(currentFieldName)) {
                                checksum = parser.text();
                                continue;
                            }
                            if ("part_size".equals(currentFieldName)) {
                                partSize = new ByteSizeValue(parser.longValue());
                                continue;
                            }
                            if ("written_by".equals(currentFieldName)) {
                                writtenBy = Lucene.parseVersionLenient(parser.text(), null);
                                continue;
                            }
                            if ("meta_hash".equals(currentFieldName)) {
                                metaHash.bytes = parser.binaryValue();
                                metaHash.offset = 0;
                                metaHash.length = metaHash.bytes.length;
                                continue;
                            }
                            throw new ElasticsearchParseException("unknown parameter [{}]", currentFieldName);
                        }
                        throw new ElasticsearchParseException("unexpected token  [{}]", new Object[]{token});
                    }
                    throw new ElasticsearchParseException("unexpected token [{}]", new Object[]{token});
                }
            }
            if (name == null || !Strings.validFileName(name)) {
                throw new ElasticsearchParseException("missing or invalid file name [" + name + "]", new Object[0]);
            }
            if (physicalName == null || !Strings.validFileName(physicalName)) {
                throw new ElasticsearchParseException("missing or invalid physical file name [" + physicalName + "]", new Object[0]);
            }
            if (length < 0L) {
                throw new ElasticsearchParseException("missing or invalid file length", new Object[0]);
            }
            return new FileInfo(name, new StoreFileMetaData(physicalName, length, checksum, writtenBy, metaHash), partSize);
        }

        static final class Fields {
            static final XContentBuilderString NAME = new XContentBuilderString("name");
            static final XContentBuilderString PHYSICAL_NAME = new XContentBuilderString("physical_name");
            static final XContentBuilderString LENGTH = new XContentBuilderString("length");
            static final XContentBuilderString CHECKSUM = new XContentBuilderString("checksum");
            static final XContentBuilderString PART_SIZE = new XContentBuilderString("part_size");
            static final XContentBuilderString WRITTEN_BY = new XContentBuilderString("written_by");
            static final XContentBuilderString META_HASH = new XContentBuilderString("meta_hash");

            Fields() {
            }
        }
    }
}

