/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.internal.AllFieldMapper;
import org.elasticsearch.index.similarity.SimilarityProvider;

public abstract class FieldMapper
extends Mapper
implements Cloneable {
    protected MappedFieldType fieldType;
    protected final MappedFieldType defaultFieldType;
    protected MultiFields multiFields;
    protected CopyTo copyTo;
    protected final boolean indexCreatedBefore2x;

    protected FieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, MultiFields multiFields, CopyTo copyTo) {
        super(simpleName);
        assert (indexSettings != null);
        this.indexCreatedBefore2x = Version.indexCreated(indexSettings).before(Version.V_2_0_0_beta1);
        fieldType.freeze();
        this.fieldType = fieldType;
        defaultFieldType.freeze();
        this.defaultFieldType = defaultFieldType;
        this.multiFields = multiFields;
        this.copyTo = copyTo;
    }

    @Override
    public String name() {
        return this.fieldType().names().fullName();
    }

    public MappedFieldType fieldType() {
        return this.fieldType;
    }

    public CopyTo copyTo() {
        return this.copyTo;
    }

    public Mapper parse(ParseContext context) throws IOException {
        ArrayList<Field> fields = new ArrayList<Field>(2);
        try {
            this.parseCreateField(context, fields);
            for (Field field : fields) {
                if (!this.customBoost()) {
                    field.setBoost(this.fieldType().boost());
                }
                context.doc().add(field);
            }
        }
        catch (Exception e) {
            throw new MapperParsingException("failed to parse [" + this.fieldType().names().fullName() + "]", e);
        }
        this.multiFields.parse(this, context);
        return null;
    }

    protected abstract void parseCreateField(ParseContext var1, List<Field> var2) throws IOException;

    protected boolean customBoost() {
        return false;
    }

    @Override
    public Iterator<Mapper> iterator() {
        return this.multiFields.iterator();
    }

    protected FieldMapper clone() {
        try {
            return (FieldMapper)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public FieldMapper merge(Mapper mergeWith, boolean updateAllTypes) {
        FieldMapper merged = this.clone();
        merged.doMerge(mergeWith, updateAllTypes);
        return merged;
    }

    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        if (!this.getClass().equals(mergeWith.getClass())) {
            String mergedType = mergeWith.getClass().getSimpleName();
            if (mergeWith instanceof FieldMapper) {
                mergedType = ((FieldMapper)mergeWith).contentType();
            }
            throw new IllegalArgumentException("mapper [" + this.fieldType().names().fullName() + "] of different type, current_type [" + this.contentType() + "], merged_type [" + mergedType + "]");
        }
        FieldMapper fieldMergeWith = (FieldMapper)mergeWith;
        this.multiFields = this.multiFields.merge(fieldMergeWith.multiFields);
        this.fieldType = fieldMergeWith.fieldType;
        this.copyTo = fieldMergeWith.copyTo;
    }

    @Override
    public FieldMapper updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
        MappedFieldType newFieldType = fullNameToFieldType.get(this.fieldType.names().fullName());
        if (newFieldType == null) {
            return this;
        }
        if (this.fieldType.getClass() != newFieldType.getClass()) {
            throw new IllegalStateException("Mixing up field types: " + this.fieldType.getClass() + " != " + newFieldType.getClass() + " on field " + this.fieldType.names().fullName());
        }
        MultiFields updatedMultiFields = this.multiFields.updateFieldType(fullNameToFieldType);
        if (this.fieldType == newFieldType && this.multiFields == updatedMultiFields) {
            return this;
        }
        FieldMapper updated = this.clone();
        updated.fieldType = newFieldType;
        updated.multiFields = updatedMultiFields;
        return updated;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.simpleName());
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        this.doXContentBody(builder, includeDefaults, params);
        return builder.endObject();
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        boolean defaultIndexed;
        builder.field("type", this.contentType());
        if (this.indexCreatedBefore2x && (includeDefaults || !this.simpleName().equals(this.fieldType().names().originalIndexName()))) {
            builder.field("index_name", this.fieldType().names().originalIndexName());
        }
        if (includeDefaults || this.fieldType().boost() != 1.0f) {
            builder.field("boost", this.fieldType().boost());
        }
        boolean indexed = this.fieldType().indexOptions() != IndexOptions.NONE;
        boolean bl = defaultIndexed = this.defaultFieldType.indexOptions() != IndexOptions.NONE;
        if (includeDefaults || indexed != defaultIndexed || this.fieldType().tokenized() != this.defaultFieldType.tokenized()) {
            builder.field("index", FieldMapper.indexTokenizeOptionToString(indexed, this.fieldType().tokenized()));
        }
        if (includeDefaults || this.fieldType().stored() != this.defaultFieldType.stored()) {
            builder.field("store", this.fieldType().stored());
        }
        this.doXContentDocValues(builder, includeDefaults);
        if (includeDefaults || this.fieldType().storeTermVectors() != this.defaultFieldType.storeTermVectors()) {
            builder.field("term_vector", FieldMapper.termVectorOptionsToString(this.fieldType()));
        }
        if (includeDefaults || this.fieldType().omitNorms() != this.defaultFieldType.omitNorms() || this.fieldType().normsLoading() != null) {
            builder.startObject("norms");
            if (includeDefaults || this.fieldType().omitNorms() != this.defaultFieldType.omitNorms()) {
                builder.field("enabled", !this.fieldType().omitNorms());
            }
            if (this.fieldType().normsLoading() != null) {
                builder.field("loading", (Object)this.fieldType().normsLoading());
            }
            builder.endObject();
        }
        if (indexed && (includeDefaults || this.fieldType().indexOptions() != this.defaultFieldType.indexOptions())) {
            builder.field("index_options", FieldMapper.indexOptionToString(this.fieldType().indexOptions()));
        }
        if (this.fieldType().similarity() != null) {
            builder.field("similarity", this.fieldType().similarity().name());
        } else if (includeDefaults) {
            builder.field("similarity", "default");
        }
        if (includeDefaults || this.hasCustomFieldDataSettings()) {
            builder.field("fielddata", (Object)this.fieldType().fieldDataType().getSettings().getAsMap());
        }
        this.multiFields.toXContent(builder, params);
        if (this.copyTo != null) {
            this.copyTo.toXContent(builder, params);
        }
    }

    protected final void doXContentAnalyzers(XContentBuilder builder, boolean includeDefaults) throws IOException {
        if (!this.fieldType.tokenized()) {
            return;
        }
        if (this.fieldType().indexAnalyzer() == null) {
            if (includeDefaults) {
                builder.field("analyzer", "default");
            }
        } else {
            boolean hasDifferentSearchQuoteAnalyzer;
            boolean hasDefaultIndexAnalyzer = this.fieldType().indexAnalyzer().name().equals("default");
            boolean hasDifferentSearchAnalyzer = !this.fieldType().searchAnalyzer().name().equals(this.fieldType().indexAnalyzer().name());
            boolean bl = hasDifferentSearchQuoteAnalyzer = !this.fieldType().searchAnalyzer().name().equals(this.fieldType().searchQuoteAnalyzer().name());
            if (includeDefaults || !hasDefaultIndexAnalyzer || hasDifferentSearchAnalyzer || hasDifferentSearchQuoteAnalyzer) {
                builder.field("analyzer", this.fieldType().indexAnalyzer().name());
                if (hasDifferentSearchAnalyzer || hasDifferentSearchQuoteAnalyzer) {
                    builder.field("search_analyzer", this.fieldType().searchAnalyzer().name());
                    if (hasDifferentSearchQuoteAnalyzer) {
                        builder.field("search_quote_analyzer", this.fieldType().searchQuoteAnalyzer().name());
                    }
                }
            }
        }
    }

    protected void doXContentDocValues(XContentBuilder builder, boolean includeDefaults) throws IOException {
        if (includeDefaults || this.defaultFieldType.hasDocValues() != this.fieldType().hasDocValues()) {
            builder.field("doc_values", this.fieldType().hasDocValues());
        }
    }

    protected static String indexOptionToString(IndexOptions indexOption) {
        switch (indexOption) {
            case DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS: {
                return "offsets";
            }
            case DOCS_AND_FREQS: {
                return "freqs";
            }
            case DOCS_AND_FREQS_AND_POSITIONS: {
                return "positions";
            }
            case DOCS: {
                return "docs";
            }
        }
        throw new IllegalArgumentException("Unknown IndexOptions [" + (Object)((Object)indexOption) + "]");
    }

    public static String termVectorOptionsToString(FieldType fieldType) {
        if (!fieldType.storeTermVectors()) {
            return "no";
        }
        if (!fieldType.storeTermVectorOffsets() && !fieldType.storeTermVectorPositions()) {
            return "yes";
        }
        if (fieldType.storeTermVectorOffsets() && !fieldType.storeTermVectorPositions()) {
            return "with_offsets";
        }
        StringBuilder builder = new StringBuilder("with");
        if (fieldType.storeTermVectorPositions()) {
            builder.append("_positions");
        }
        if (fieldType.storeTermVectorOffsets()) {
            builder.append("_offsets");
        }
        if (fieldType.storeTermVectorPayloads()) {
            builder.append("_payloads");
        }
        return builder.toString();
    }

    protected static String indexTokenizeOptionToString(boolean indexed, boolean tokenized) {
        if (!indexed) {
            return "no";
        }
        if (tokenized) {
            return "analyzed";
        }
        return "not_analyzed";
    }

    protected boolean hasCustomFieldDataSettings() {
        return this.fieldType().fieldDataType() != null && !this.fieldType().fieldDataType().equals(this.defaultFieldType.fieldDataType());
    }

    protected abstract String contentType();

    public boolean isGenerated() {
        return false;
    }

    public static class CopyTo {
        private final List<String> copyToFields;

        private CopyTo(List<String> copyToFields) {
            this.copyToFields = copyToFields;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (!this.copyToFields.isEmpty()) {
                builder.startArray("copy_to");
                for (String field : this.copyToFields) {
                    builder.value(field);
                }
                builder.endArray();
            }
            return builder;
        }

        public List<String> copyToFields() {
            return this.copyToFields;
        }

        public static class Builder {
            private final List<String> copyToBuilders = new ArrayList<String>();

            public Builder add(String field) {
                this.copyToBuilders.add(field);
                return this;
            }

            public CopyTo build() {
                return new CopyTo(Collections.unmodifiableList(this.copyToBuilders));
            }
        }
    }

    public static class MultiFields {
        private final ContentPath.Type pathType;
        private final ImmutableOpenMap<String, FieldMapper> mappers;

        public static MultiFields empty() {
            return new MultiFields(ContentPath.Type.FULL, ImmutableOpenMap.of());
        }

        private MultiFields(ContentPath.Type pathType, ImmutableOpenMap<String, FieldMapper> mappers) {
            this.pathType = pathType;
            ImmutableOpenMap.Builder builder = new ImmutableOpenMap.Builder();
            for (ObjectObjectCursor<String, FieldMapper> objectObjectCursor : mappers) {
                FieldMapper mapper = (FieldMapper)objectObjectCursor.value;
                if (mapper instanceof AllFieldMapper.IncludeInAll) {
                    mapper = (FieldMapper)((AllFieldMapper.IncludeInAll)((Object)mapper)).unsetIncludeInAll();
                }
                builder.put(objectObjectCursor.key, mapper);
            }
            this.mappers = builder.build();
        }

        public void parse(FieldMapper mainField, ParseContext context) throws IOException {
            if (this.mappers.isEmpty()) {
                return;
            }
            context = context.createMultiFieldContext();
            ContentPath.Type origPathType = context.path().pathType();
            context.path().pathType(this.pathType);
            context.path().add(mainField.simpleName());
            for (ObjectCursor<FieldMapper> objectCursor : this.mappers.values()) {
                ((FieldMapper)objectCursor.value).parse(context);
            }
            context.path().remove();
            context.path().pathType(origPathType);
        }

        public MultiFields merge(MultiFields mergeWith) {
            if (this.pathType != mergeWith.pathType) {
                throw new IllegalArgumentException("Can't change path type from [" + (Object)((Object)this.pathType) + "] to [" + (Object)((Object)mergeWith.pathType) + "]");
            }
            ImmutableOpenMap.Builder<String, FieldMapper> newMappersBuilder = ImmutableOpenMap.builder(this.mappers);
            for (ObjectCursor<FieldMapper> objectCursor : mergeWith.mappers.values()) {
                FieldMapper mergeWithMapper = (FieldMapper)objectCursor.value;
                FieldMapper mergeIntoMapper = this.mappers.get(mergeWithMapper.simpleName());
                if (mergeIntoMapper == null) {
                    if (mergeWithMapper instanceof AllFieldMapper.IncludeInAll) {
                        mergeWithMapper = (FieldMapper)((AllFieldMapper.IncludeInAll)((Object)mergeWithMapper)).unsetIncludeInAll();
                    }
                    newMappersBuilder.put(mergeWithMapper.simpleName(), mergeWithMapper);
                    continue;
                }
                FieldMapper merged = mergeIntoMapper.merge(mergeWithMapper, false);
                newMappersBuilder.put(merged.simpleName(), merged);
            }
            ImmutableOpenMap<String, FieldMapper> mappers = newMappersBuilder.build();
            return new MultiFields(this.pathType, mappers);
        }

        public MultiFields updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
            ImmutableOpenMap.Builder<String, FieldMapper> newMappersBuilder = null;
            for (ObjectCursor<FieldMapper> objectCursor : this.mappers.values()) {
                Mapper updated = ((FieldMapper)objectCursor.value).updateFieldType((Map)fullNameToFieldType);
                if (updated == objectCursor.value) continue;
                if (newMappersBuilder == null) {
                    newMappersBuilder = ImmutableOpenMap.builder(this.mappers);
                }
                newMappersBuilder.put(updated.simpleName(), (FieldMapper)updated);
            }
            if (newMappersBuilder == null) {
                return this;
            }
            ImmutableOpenMap<String, FieldMapper> mappers = newMappersBuilder.build();
            return new MultiFields(this.pathType, mappers);
        }

        public Iterator<Mapper> iterator() {
            return Iterators.transform(this.mappers.values().iterator(), (Function)new Function<ObjectCursor<FieldMapper>, Mapper>(){

                public Mapper apply(@Nullable ObjectCursor<FieldMapper> cursor) {
                    return (Mapper)cursor.value;
                }
            });
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.pathType != ContentPath.Type.FULL) {
                builder.field("path", this.pathType.name().toLowerCase(Locale.ROOT));
            }
            if (!this.mappers.isEmpty()) {
                Mapper[] sortedMappers = this.mappers.values().toArray(Mapper.class);
                Arrays.sort(sortedMappers, new Comparator<Mapper>(){

                    @Override
                    public int compare(Mapper o1, Mapper o2) {
                        return o1.name().compareTo(o2.name());
                    }
                });
                builder.startObject("fields");
                for (Mapper mapper : sortedMappers) {
                    mapper.toXContent(builder, params);
                }
                builder.endObject();
            }
            return builder;
        }

        public static class Builder {
            private final ImmutableOpenMap.Builder<String, Mapper.Builder> mapperBuilders = ImmutableOpenMap.builder();
            private ContentPath.Type pathType = ContentPath.Type.FULL;

            public Builder pathType(ContentPath.Type pathType) {
                this.pathType = pathType;
                return this;
            }

            public Builder add(Mapper.Builder builder) {
                this.mapperBuilders.put(builder.name(), builder);
                return this;
            }

            public MultiFields build(org.elasticsearch.index.mapper.FieldMapper$Builder mainFieldBuilder, Mapper.BuilderContext context) {
                if (this.pathType == ContentPath.Type.FULL && this.mapperBuilders.isEmpty()) {
                    return MultiFields.empty();
                }
                if (this.mapperBuilders.isEmpty()) {
                    return new MultiFields(this.pathType, ImmutableOpenMap.of());
                }
                ContentPath.Type origPathType = context.path().pathType();
                context.path().pathType(this.pathType);
                context.path().add(mainFieldBuilder.name());
                ImmutableOpenMap.Builder<String, Mapper.Builder> mapperBuilders = this.mapperBuilders;
                for (ObjectObjectCursor<String, Mapper.Builder> objectObjectCursor : this.mapperBuilders) {
                    String key = (String)objectObjectCursor.key;
                    Mapper.Builder value = (Mapper.Builder)objectObjectCursor.value;
                    Object mapper = value.build(context);
                    assert (mapper instanceof FieldMapper);
                    mapperBuilders.put(key, (Mapper.Builder)mapper);
                }
                context.path().remove();
                context.path().pathType(origPathType);
                ImmutableOpenMap.Builder mappers = mapperBuilders.cast();
                return new MultiFields(this.pathType, mappers.build());
            }
        }
    }

    public static abstract class Builder<T extends Builder, Y extends FieldMapper>
    extends Mapper.Builder<T, Y> {
        protected final MappedFieldType fieldType;
        protected final MappedFieldType defaultFieldType;
        private final IndexOptions defaultOptions;
        protected boolean omitNormsSet = false;
        protected String indexName;
        protected Boolean includeInAll;
        protected boolean indexOptionsSet = false;
        protected boolean docValuesSet = false;
        @Nullable
        protected Settings fieldDataSettings;
        protected final MultiFields.Builder multiFieldsBuilder;
        protected CopyTo copyTo;

        protected Builder(String name, MappedFieldType fieldType, MappedFieldType defaultFieldType) {
            super(name);
            this.fieldType = fieldType.clone();
            this.defaultFieldType = defaultFieldType.clone();
            this.defaultOptions = fieldType.indexOptions();
            this.multiFieldsBuilder = new MultiFields.Builder();
        }

        public MappedFieldType fieldType() {
            return this.fieldType;
        }

        public T index(boolean index) {
            if (index) {
                if (this.fieldType.indexOptions() == IndexOptions.NONE) {
                    IndexOptions options = this.getDefaultIndexOption();
                    if (options == IndexOptions.NONE) {
                        throw new IllegalArgumentException("mapper [" + this.name + "] has different [index] values from other types of the same index");
                    }
                    this.fieldType.setIndexOptions(options);
                }
            } else {
                this.fieldType.setIndexOptions(IndexOptions.NONE);
            }
            return (T)((Builder)this.builder);
        }

        protected IndexOptions getDefaultIndexOption() {
            return this.defaultOptions;
        }

        public T store(boolean store) {
            this.fieldType.setStored(store);
            return (T)((Builder)this.builder);
        }

        public T docValues(boolean docValues) {
            this.fieldType.setHasDocValues(docValues);
            this.docValuesSet = true;
            return (T)((Builder)this.builder);
        }

        public T storeTermVectors(boolean termVectors) {
            if (termVectors != this.fieldType.storeTermVectors()) {
                this.fieldType.setStoreTermVectors(termVectors);
            }
            return (T)((Builder)this.builder);
        }

        public T storeTermVectorOffsets(boolean termVectorOffsets) {
            if (termVectorOffsets) {
                this.fieldType.setStoreTermVectors(termVectorOffsets);
            }
            this.fieldType.setStoreTermVectorOffsets(termVectorOffsets);
            return (T)((Builder)this.builder);
        }

        public T storeTermVectorPositions(boolean termVectorPositions) {
            if (termVectorPositions) {
                this.fieldType.setStoreTermVectors(termVectorPositions);
            }
            this.fieldType.setStoreTermVectorPositions(termVectorPositions);
            return (T)((Builder)this.builder);
        }

        public T storeTermVectorPayloads(boolean termVectorPayloads) {
            if (termVectorPayloads) {
                this.fieldType.setStoreTermVectors(termVectorPayloads);
            }
            this.fieldType.setStoreTermVectorPayloads(termVectorPayloads);
            return (T)((Builder)this.builder);
        }

        public T tokenized(boolean tokenized) {
            this.fieldType.setTokenized(tokenized);
            return (T)((Builder)this.builder);
        }

        public T boost(float boost) {
            this.fieldType.setBoost(boost);
            return (T)((Builder)this.builder);
        }

        public T omitNorms(boolean omitNorms) {
            this.fieldType.setOmitNorms(omitNorms);
            this.omitNormsSet = true;
            return (T)((Builder)this.builder);
        }

        public T indexOptions(IndexOptions indexOptions) {
            this.fieldType.setIndexOptions(indexOptions);
            this.indexOptionsSet = true;
            return (T)((Builder)this.builder);
        }

        public T indexName(String indexName) {
            this.indexName = indexName;
            return (T)((Builder)this.builder);
        }

        public T indexAnalyzer(NamedAnalyzer indexAnalyzer) {
            this.fieldType.setIndexAnalyzer(indexAnalyzer);
            return (T)((Builder)this.builder);
        }

        public T searchAnalyzer(NamedAnalyzer searchAnalyzer) {
            this.fieldType.setSearchAnalyzer(searchAnalyzer);
            return (T)((Builder)this.builder);
        }

        public T includeInAll(Boolean includeInAll) {
            this.includeInAll = includeInAll;
            return (T)((Builder)this.builder);
        }

        public T similarity(SimilarityProvider similarity) {
            this.fieldType.setSimilarity(similarity);
            return (T)((Builder)this.builder);
        }

        public T normsLoading(MappedFieldType.Loading normsLoading) {
            this.fieldType.setNormsLoading(normsLoading);
            return (T)((Builder)this.builder);
        }

        public T fieldDataSettings(Settings settings) {
            this.fieldDataSettings = settings;
            return (T)((Builder)this.builder);
        }

        public Builder nullValue(Object nullValue) {
            this.fieldType.setNullValue(nullValue);
            return this;
        }

        public T multiFieldPathType(ContentPath.Type pathType) {
            this.multiFieldsBuilder.pathType(pathType);
            return (T)((Builder)this.builder);
        }

        public T addMultiField(Mapper.Builder mapperBuilder) {
            this.multiFieldsBuilder.add(mapperBuilder);
            return (T)((Builder)this.builder);
        }

        public T copyTo(CopyTo copyTo) {
            this.copyTo = copyTo;
            return (T)((Builder)this.builder);
        }

        protected MappedFieldType.Names buildNames(Mapper.BuilderContext context) {
            return new MappedFieldType.Names(this.buildIndexName(context), this.buildIndexNameClean(context), this.buildFullName(context));
        }

        protected String buildIndexName(Mapper.BuilderContext context) {
            if (context.indexCreatedVersion().onOrAfter(Version.V_2_0_0_beta1)) {
                return this.buildFullName(context);
            }
            String actualIndexName = this.indexName == null ? this.name : this.indexName;
            return context.path().pathAsText(actualIndexName);
        }

        protected String buildIndexNameClean(Mapper.BuilderContext context) {
            if (context.indexCreatedVersion().onOrAfter(Version.V_2_0_0_beta1)) {
                return this.buildFullName(context);
            }
            return this.indexName == null ? this.name : this.indexName;
        }

        protected String buildFullName(Mapper.BuilderContext context) {
            return context.path().fullPathAsText(this.name);
        }

        protected void setupFieldType(Mapper.BuilderContext context) {
            boolean fieldDataDocValues;
            this.fieldType.setNames(this.buildNames(context));
            if (this.fieldType.indexAnalyzer() == null && !this.fieldType.tokenized() && this.fieldType.indexOptions() != IndexOptions.NONE) {
                this.fieldType.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
                this.fieldType.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            }
            if (this.fieldDataSettings != null) {
                Settings settings = Settings.builder().put(this.fieldType.fieldDataType().getSettings()).put(this.fieldDataSettings).build();
                this.fieldType.setFieldDataType(new FieldDataType(this.fieldType.fieldDataType().getType(), settings));
            }
            boolean defaultDocValues = false;
            if (context.indexCreatedVersion().onOrAfter(Version.V_2_0_0_beta1)) {
                defaultDocValues = !this.fieldType.tokenized() && this.fieldType.indexOptions() != IndexOptions.NONE;
            }
            boolean bl = fieldDataDocValues = this.fieldType.fieldDataType() != null && "doc_values".equals(this.fieldType.fieldDataType().getFormat(context.indexSettings()));
            if (fieldDataDocValues && this.docValuesSet && !this.fieldType.hasDocValues()) {
                defaultDocValues = true;
            }
            this.defaultFieldType.setHasDocValues(defaultDocValues);
            if (!this.docValuesSet) {
                this.fieldType.setHasDocValues(defaultDocValues || fieldDataDocValues);
            }
        }
    }
}

