/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ngram.Lucene43NGramTokenizer;
import org.apache.lucene.analysis.ngram.NGramTokenizer;
import org.elasticsearch.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;
import org.elasticsearch.index.analysis.CharMatcher;
import org.elasticsearch.index.settings.IndexSettingsService;

public class NGramTokenizerFactory
extends AbstractTokenizerFactory {
    private final int minGram;
    private final int maxGram;
    private final CharMatcher matcher;
    private Version esVersion;
    static final Map<String, CharMatcher> MATCHERS;

    static CharMatcher parseTokenChars(String[] characterClasses) {
        if (characterClasses == null || characterClasses.length == 0) {
            return null;
        }
        CharMatcher.Builder builder = new CharMatcher.Builder();
        for (String characterClass : characterClasses) {
            CharMatcher matcher = MATCHERS.get(characterClass = characterClass.toLowerCase(Locale.ROOT).trim());
            if (matcher == null) {
                throw new IllegalArgumentException("Unknown token type: '" + characterClass + "', must be one of " + MATCHERS.keySet());
            }
            builder.or(matcher);
        }
        return builder.build();
    }

    @Inject
    public NGramTokenizerFactory(Index index, IndexSettingsService indexSettingsService, @Assisted String name, @Assisted Settings settings) {
        this(index, indexSettingsService.getSettings(), name, settings);
    }

    NGramTokenizerFactory(Index index, Settings indexSettings, String name, Settings settings) {
        super(index, indexSettings, name, settings);
        this.minGram = settings.getAsInt("min_gram", (Integer)1);
        this.maxGram = settings.getAsInt("max_gram", (Integer)2);
        this.matcher = NGramTokenizerFactory.parseTokenChars(settings.getAsArray("token_chars"));
        this.esVersion = Version.indexCreated(indexSettings);
    }

    @Override
    public Tokenizer create() {
        if (this.version.onOrAfter(org.apache.lucene.util.Version.LUCENE_4_3) && this.esVersion.onOrAfter(Version.V_0_90_2)) {
            org.apache.lucene.util.Version version;
            org.apache.lucene.util.Version version2 = version = this.version == org.apache.lucene.util.Version.LUCENE_4_3 ? org.apache.lucene.util.Version.LUCENE_4_4 : this.version;
            if (this.matcher == null) {
                return new NGramTokenizer(this.minGram, this.maxGram);
            }
            return new NGramTokenizer(this.minGram, this.maxGram){

                @Override
                protected boolean isTokenChar(int chr) {
                    return NGramTokenizerFactory.this.matcher.isTokenChar(chr);
                }
            };
        }
        return new Lucene43NGramTokenizer(this.minGram, this.maxGram);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"letter", (Object)CharMatcher.Basic.LETTER);
        builder.put((Object)"digit", (Object)CharMatcher.Basic.DIGIT);
        builder.put((Object)"whitespace", (Object)CharMatcher.Basic.WHITESPACE);
        builder.put((Object)"punctuation", (Object)CharMatcher.Basic.PUNCTUATION);
        builder.put((Object)"symbol", (Object)CharMatcher.Basic.SYMBOL);
        for (Field field : Character.class.getFields()) {
            if (field.getName().startsWith("DIRECTIONALITY") || !Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || field.getType() != Byte.TYPE) continue;
            try {
                builder.put((Object)field.getName().toLowerCase(Locale.ROOT), (Object)CharMatcher.ByUnicodeCategory.of(field.getByte(null)));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        MATCHERS = builder.build();
    }
}

