/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.upgrade;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.upgrade.Dependencies;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;

@Named
@Singleton
@Upgrades(model="pypi", from="1.1", to="1.2")
@Dependencies(value={@DependsOn(model="component", version="1.14", checkpoint=true), @DependsOn(model="config", version="1.8")})
public class PyPiUpgrade_1_2
extends DatabaseUpgradeSupport {
    public static final String MARKER_FILE = String.valueOf(PyPiUpgrade_1_2.class.getSimpleName()) + ".marker";
    private Path markerFile;

    @Inject
    public PyPiUpgrade_1_2(ApplicationDirectories directories) {
        this.markerFile = new File(directories.getWorkDirectory("db"), MARKER_FILE).toPath();
    }

    public void apply() throws Exception {
        if (!Files.exists(this.markerFile, new LinkOption[0])) {
            Files.createFile(this.markerFile, new FileAttribute[0]);
        }
    }
}

