/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.rest;

import com.sonatype.nexus.repository.pypi.rest.PyPiProxyApiRepository;
import com.sonatype.nexus.repository.pypi.rest.PyPiProxyAttributes;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.api.SimpleApiRepositoryAdapter;
import org.sonatype.nexus.repository.rest.api.model.AbstractApiRepository;
import org.sonatype.nexus.repository.rest.api.model.StorageAttributes;
import org.sonatype.nexus.repository.routing.RoutingRuleStore;

@Named(value="pypi")
public class PyPiApiRepositoryAdapter
extends SimpleApiRepositoryAdapter {
    @Inject
    public PyPiApiRepositoryAdapter(RoutingRuleStore routingRuleStore) {
        super(routingRuleStore);
    }

    public AbstractApiRepository adapt(Repository repository) {
        if ("proxy".equals(repository.getType().toString())) {
            return new PyPiProxyApiRepository(repository.getName(), repository.getUrl(), repository.getConfiguration().isOnline(), (StorageAttributes)this.getHostedStorageAttributes(repository), this.getCleanupPolicyAttributes(repository), this.getProxyAttributes(repository), this.getNegativeCacheAttributes(repository), this.getHttpClientAttributes(repository), this.getRoutingRuleName(repository), this.createPypiAttributes(repository), this.getReplicationAttributes(repository));
        }
        return super.adapt(repository);
    }

    private PyPiProxyAttributes createPypiAttributes(Repository repository) {
        Boolean removeQuarantined = (Boolean)repository.getConfiguration().attributes("pypi").get("removeQuarantinedVersions", Boolean.class, (Object)Boolean.FALSE);
        return new PyPiProxyAttributes(removeQuarantined);
    }
}

