/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.orient.tasks;

import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import com.sonatype.nexus.repository.pypi.AssetKind;
import com.sonatype.nexus.repository.pypi.PyPiFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.logging.task.TaskLogType;
import org.sonatype.nexus.logging.task.TaskLogging;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.types.ProxyType;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
@TaskLogging(value=TaskLogType.NEXUS_LOG_ONLY)
public class OrientPyPiDeleteIndexAssetTask
extends TaskSupport
implements Cancelable {
    private final RepositoryManager repositoryManager;

    @Inject
    public OrientPyPiDeleteIndexAssetTask(RepositoryManager repositoryManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    protected Object execute() throws Exception {
        ResultCount resultCount = new ResultCount();
        Streams.stream((Iterable)this.repositoryManager.browse()).peek(r -> this.log.debug("Looking at repository: {}", r)).filter(repository -> repository.getFormat() instanceof PyPiFormat).filter(repository -> !(repository.getType() instanceof ProxyType)).forEach(repository -> this.deleteIndexAsset((Repository)repository, resultCount));
        this.log.info("Completed processing a total of {} assets. {} deleted, {} skipped and {} errors.", new Object[]{resultCount.total, resultCount.deleted, resultCount.skipped, resultCount.error});
        return null;
    }

    private void deleteIndexAsset(Repository repository, ResultCount resultCount) {
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (StorageTx tx = (StorageTx)storageFacet.txSupplier().get();){
            tx.begin();
            Bucket bucket = tx.findBucket(repository);
            Streams.stream((Iterable)tx.browseAssets(bucket)).peek(a -> this.log.debug("Evaluating asset: {}", (Object)a.name())).filter(asset -> this.validateIndexAssetForDeletion((Asset)asset, storageFacet, resultCount)).forEach(a -> {
                CancelableHelper.checkCancellation();
                tx.deleteAsset(a);
            });
            tx.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateIndexAssetForDeletion(Asset asset, StorageFacet facet, ResultCount resultCount) {
        CancelableHelper.checkCancellation();
        blob = facet.blobStore().get(asset.blobRef().getBlobId());
        assetKind = (String)asset.attributes().child("pypi").get("asset_kind");
        if (assetKind != null && blob != null && assetKind.equals(AssetKind.INDEX.name())) {
            try {
                var6_6 = null;
                var7_9 = null;
                try {
                    downloadedAsset = blob.getInputStream();
                    try {
                        block19: {
                            block20: {
                                reader = new BufferedReader(new InputStreamReader(downloadedAsset, StandardCharsets.UTF_8));
                                if (!reader.lines().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$7(java.lang.String ), (Ljava/lang/String;)Z)())) break block19;
                                this.log.info("Marking the {} asset: {} for deletion", (Object)assetKind, (Object)asset.name());
                                v0 = resultCount;
                                ResultCount.access$5(v0, ResultCount.access$2(v0) + 1);
                                if (reader == null) break block20;
                                {
                                    catch (Throwable var6_7) {
                                        throw var6_7;
                                    }
                                }
                                reader.close();
                            }
                            if (downloadedAsset == null) return true;
                            downloadedAsset.close();
                            return true;
                        }
                        this.log.info("Valid checksum present for pypi index asset. Skipping");
                        v1 = resultCount;
                        ResultCount.access$6(v1, ResultCount.access$3(v1) + 1);
                        break block21;
                    }
                    catch (Throwable var7_10) {
                        if (var6_6 == null) {
                            var6_6 = var7_10;
                        } else if (var6_6 != var7_10) {
                            var6_6.addSuppressed(var7_10);
                        }
                        if (downloadedAsset == null) throw var6_6;
                        downloadedAsset.close();
                        throw var6_6;
                    }
                    {
                        block21: {
                            finally {
                                if (reader != null) {
                                    reader.close();
                                }
                            }
                        }
                        ** if (downloadedAsset == null) goto lbl-1000
                    }
lbl-1000:
                    // 1 sources

                    {
                        downloadedAsset.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                catch (Throwable var7_11) {
                    if (var6_6 == null) {
                        var6_6 = var7_11;
                        throw var6_6;
                    }
                    if (var6_6 == var7_11) throw var6_6;
                    var6_6.addSuppressed(var7_11);
                    throw var6_6;
                }
            }
            catch (IOException e) {
                this.log.debug("Unexpected exception when reading the index asset blob {}", (Object)e.getMessage());
                v2 = resultCount;
                ResultCount.access$7(v2, ResultCount.access$4(v2) + 1);
            }
        } else {
            v3 = resultCount;
            ResultCount.access$6(v3, ResultCount.access$3(v3) + 1);
        }
        v4 = resultCount;
        ResultCount.access$8(v4, ResultCount.access$1(v4) + 1);
        return false;
    }

    public String getMessage() {
        return "Deleting index asset if MD5 Checksum is found";
    }

    private static /* synthetic */ boolean lambda$7(String htmlIndex) {
        return htmlIndex.contains("#md5=");
    }

    private static class ResultCount {
        private int deleted;
        private int skipped;
        private int error;
        private int total;

        private ResultCount() {
        }

        static /* synthetic */ void access$5(ResultCount resultCount, int n) {
            resultCount.deleted = n;
        }

        static /* synthetic */ void access$6(ResultCount resultCount, int n) {
            resultCount.skipped = n;
        }

        static /* synthetic */ void access$7(ResultCount resultCount, int n) {
            resultCount.error = n;
        }

        static /* synthetic */ void access$8(ResultCount resultCount, int n) {
            resultCount.total = n;
        }
    }
}

