/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.orient.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.sonatype.nexus.repository.pypi.AssetKind;
import com.sonatype.nexus.repository.pypi.PyPiInfoUtils;
import com.sonatype.nexus.repository.pypi.PyPiPathUtils;
import com.sonatype.nexus.repository.pypi.PyPiQuarantinedVersionFacet;
import com.sonatype.nexus.repository.pypi.internal.PyPiFileUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiIndexUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiLink;
import com.sonatype.nexus.repository.pypi.internal.PyPiStorageUtils;
import com.sonatype.nexus.repository.pypi.orient.internal.OrientPyPiDataUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.sonatype.nexus.common.template.TemplateHelper;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientPyPiProxyFacetImpl
extends ProxyFacetSupport {
    private final HashFunction etagDigester = Hashing.sha256();
    private final TemplateHelper templateHelper;

    @Inject
    public OrientPyPiProxyFacetImpl(TemplateHelper templateHelper) {
        this.templateHelper = (TemplateHelper)Preconditions.checkNotNull((Object)templateHelper);
    }

    @Nullable
    protected Content getCachedContent(Context context) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        if (assetKind.equals((Object)AssetKind.SEARCH)) {
            return null;
        }
        TokenMatcher.State state = PyPiPathUtils.matcherState(context);
        switch (assetKind) {
            case ROOT_INDEX: {
                return this.getAsset("simple/");
            }
            case INDEX: {
                return this.rewriteIndex(PyPiPathUtils.name(state));
            }
            case PACKAGE: {
                return this.getAsset(PyPiPathUtils.path(state));
            }
        }
        throw new IllegalStateException();
    }

    @Nullable
    protected Content fetch(Context context, Content stale) throws IOException {
        try {
            return super.fetch(context, stale);
        }
        catch (ProxyFacetSupport.NonResolvablePackageException ex) {
            this.log.debug("Failed to resolve package {}", (Object)ex.getMessage());
            return null;
        }
    }

    protected Content store(Context context, Content content) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        if (assetKind.equals((Object)AssetKind.SEARCH)) {
            return content;
        }
        TokenMatcher.State state = PyPiPathUtils.matcherState(context);
        switch (assetKind) {
            case ROOT_INDEX: {
                return this.putRootIndex(content);
            }
            case INDEX: {
                String name = PyPiPathUtils.name(state);
                return this.putIndex(name, content);
            }
            case PACKAGE: {
                return this.putPackage(PyPiPathUtils.path(state), content);
            }
        }
        throw new IllegalStateException();
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) throws IOException {
        this.setCacheInfo(content, cacheInfo);
    }

    protected String getUrl(@Nonnull Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        if (AssetKind.PACKAGE == assetKind) {
            return this.getPackageUrl(context);
        }
        return context.getRequest().getPath().substring(1);
    }

    private String getPackageUrl(Context context) {
        String filename;
        String packageName = PyPiPathUtils.packageNameFromPath(context.getRequest().getPath());
        PyPiLink link = this.getExistingPackageLink(packageName, filename = PyPiFileUtils.extractFilenameFromPath(context.getRequest().getPath())).orElseGet(() -> this.cachePackageRootMetadataAndRetrieveLink(context, packageName, filename));
        if (link == null) {
            throw new ProxyFacetSupport.NonResolvablePackageException("Unable to find reference for " + filename + " in package " + packageName);
        }
        URI remoteUrl = this.getRemoteUrl();
        if (!remoteUrl.getPath().endsWith("/")) {
            remoteUrl = URI.create(String.valueOf(remoteUrl.toString()) + "/");
        }
        remoteUrl = remoteUrl.resolve(PyPiPathUtils.indexPath(packageName));
        return remoteUrl.resolve(link.getLink()).toString();
    }

    private PyPiLink cachePackageRootMetadataAndRetrieveLink(Context context, String packageName, String filename) {
        try {
            this.tryCachingPackageIndex(packageName, context);
            return this.getExistingPackageLink(packageName, filename).orElse(null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Optional<PyPiLink> getExistingPackageLink(String packageName, String filename) {
        Content index = this.getAsset(PyPiPathUtils.indexPath(packageName));
        if (index == null) {
            return Optional.empty();
        }
        String rootFilename = filename.endsWith(".asc") ? filename.substring(0, filename.length() - 4) : filename;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream in = index.openInputStream();){
                return PyPiIndexUtils.extractLinksFromIndex(in).stream().filter(link -> rootFilename.equals(link.getFile())).findFirst();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void tryCachingPackageIndex(String packageName, Context context) throws IOException {
        try {
            Request getRequest = new Request.Builder().action("GET").path(String.valueOf('/') + PyPiPathUtils.indexPath(packageName)).build();
            Response response = ((ViewFacet)this.getRepository().facet(ViewFacet.class)).dispatch(getRequest, context);
            if (!response.getStatus().isSuccessful()) {
                this.log.debug("Could not retrieve package {}", (Object)packageName);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IOException(e);
        }
    }

    protected HttpRequestBase buildFetchHttpRequest(URI uri, Context context) {
        Request request = context.getRequest();
        if (PyPiPathUtils.isSearchRequest(request)) {
            Payload payload = (Payload)Preconditions.checkNotNull((Object)request.getPayload());
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream inputStream = payload.openInputStream();){
                    ContentType contentType = ContentType.parse((String)payload.getContentType());
                    HttpPost post = new HttpPost(uri);
                    post.setEntity((HttpEntity)new ByteArrayEntity(IOUtils.toByteArray((InputStream)inputStream), contentType));
                    return post;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return super.buildFetchHttpRequest(uri, context);
    }

    @TransactionalTouchBlob
    protected Content getAsset(String name) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = OrientPyPiDataUtils.findAsset(tx, tx.findBucket(this.getRepository()), name);
        if (asset == null) {
            return null;
        }
        return OrientPyPiDataUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    private Content putPackage(String path, Content content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, PyPiStorageUtils.HASH_ALGORITHMS);){
            return this.doPutPackage(path, tempBlob, (Payload)content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutPackage(String path, TempBlob tempBlob, Payload payload) throws IOException {
        Asset asset;
        Map<String, String> attributes;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        String filename = PyPiFileUtils.extractFilenameFromPath(path);
        Throwable throwable = null;
        Object var9_9 = null;
        try (InputStream is = tempBlob.get();){
            attributes = PyPiInfoUtils.extractMetadata(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!attributes.containsKey("name")) {
            this.log.debug("No name found in metadata for {}, extracting from filename.", (Object)filename);
            attributes.put("name", PyPiFileUtils.extractNameFromFilename(filename));
        }
        if (!attributes.containsKey("version")) {
            this.log.debug("No version found in metadata for {}, extracting from filename.", (Object)filename);
            attributes.put("version", PyPiFileUtils.extractVersionFromFilename(filename));
        }
        String name = attributes.get("name");
        String version = attributes.get("version");
        String normalizedName = PyPiPathUtils.normalizeName(name);
        Component component = OrientPyPiDataUtils.findComponent(tx, this.getRepository(), normalizedName, version);
        if (component == null) {
            component = OrientPyPiDataUtils.createComponent(name, version, normalizedName, tx, bucket);
        }
        if (component.isNew() || attributes.containsKey("summary")) {
            component.formatAttributes().set("summary", (Object)attributes.get("summary"));
            tx.saveComponent(component);
        }
        if ((asset = OrientPyPiDataUtils.findAsset(tx, bucket, path)) == null) {
            asset = tx.createAsset(bucket, component);
            asset.name(path);
            asset.formatAttributes().set("asset_kind", (Object)AssetKind.PACKAGE.name());
        }
        OrientPyPiDataUtils.copyAttributes(asset, attributes);
        return OrientPyPiDataUtils.saveAsset(tx, asset, tempBlob, payload);
    }

    private Content putRootIndex(Content content) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = content.openInputStream();){
            List<PyPiLink> links = PyPiIndexUtils.makeRootIndexRelative(inputStream);
            String indexPage = PyPiIndexUtils.buildRootIndexPage(this.templateHelper, links);
            return this.storeHtmlPage(content, indexPage, AssetKind.ROOT_INDEX, "simple/");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Content putIndex(String name, Content content) throws IOException {
        String path = PyPiPathUtils.indexPath(name);
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (InputStream inputStream = content.openInputStream();){
                String html = IOUtils.toString((InputStream)inputStream);
                if (!PyPiIndexUtils.validateIndexLinks(name, PyPiIndexUtils.extractLinksFromIndex(html))) {
                    return null;
                }
                PyPiIndexUtils.makeIndexLinksNexusPaths(name, inputStream);
                this.storeHtmlPage(content, html, AssetKind.INDEX, path);
                return this.rewriteIndex(name);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private Content rewriteIndex(String name) throws IOException {
        Content content = this.getAsset(PyPiPathUtils.indexPath(name));
        if (content == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inputStream = content.openInputStream();){
                List<PyPiLink> links = PyPiIndexUtils.makeIndexLinksNexusPaths(name, inputStream);
                List<PyPiLink> allowedLinks = ((PyPiQuarantinedVersionFacet)this.getRepository().facet(PyPiQuarantinedVersionFacet.class)).filterLinks(links, name);
                String truncatedPackageName = PyPiPathUtils.truncatePackageName(name);
                String html = PyPiIndexUtils.buildIndexPage(this.templateHelper, truncatedPackageName, allowedLinks);
                Content newContent = new Content((Payload)new BytesPayload(html.getBytes(), "text/html"));
                content.getAttributes().forEach(e -> {
                    Object object = newContent.getAttributes().set((String)e.getKey(), e.getValue());
                });
                this.updateEtag(newContent, html);
                return newContent;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e2) {
            this.log.warn("An error occurred re-writing the index for package {}", (Object)name, (Object)e2);
            return null;
        }
    }

    private void updateEtag(Content content, String html) {
        Hasher etagDigest = this.etagDigester.newHasher();
        etagDigest.putString((CharSequence)html, StandardCharsets.UTF_8);
        content.getAttributes().set("etag", (Object)etagDigest.hash().toString());
    }

    /*
     * Loose catch block
     */
    private Content storeHtmlPage(Content content, String indexPage, AssetKind rootIndex, String indexPathPrefix) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (ByteArrayInputStream stream = new ByteArrayInputStream(indexPage.getBytes(StandardCharsets.UTF_8));){
            Content content2;
            TempBlob tempBlob;
            Throwable throwable2;
            block19: {
                throwable2 = null;
                Object var10_13 = null;
                tempBlob = storageFacet.createTempBlob((InputStream)stream, PyPiStorageUtils.HASH_ALGORITHMS);
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("asset_kind", rootIndex.name());
                content2 = this.doPutIndex(indexPathPrefix, tempBlob, (Payload)content, attributes);
                if (tempBlob == null) break block19;
                tempBlob.close();
            }
            return content2;
            {
                catch (Throwable throwable3) {
                    try {
                        if (tempBlob != null) {
                            tempBlob.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutIndex(String name, TempBlob tempBlob, Payload payload, Map<String, Object> attributes) throws IOException {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = OrientPyPiDataUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), name);
        if (asset == null) {
            asset = tx.createAsset(bucket, this.getRepository().getFormat());
            asset.name(name);
        }
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                asset.formatAttributes().set(entry.getKey(), entry.getValue());
            }
        }
        return OrientPyPiDataUtils.saveAsset(tx, asset, tempBlob, payload);
    }

    @TransactionalTouchMetadata
    protected void setCacheInfo(Content content, CacheInfo cacheInfo) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = Content.findAsset((StorageTx)tx, (Bucket)tx.findBucket(this.getRepository()), (Content)content);
        if (asset == null) {
            this.log.debug("Attempting to set cache info for non-existent pypi asset {}", content.getAttributes().require(Asset.class));
            return;
        }
        this.log.debug("Updating cacheInfo of {} to {}", (Object)asset, (Object)cacheInfo);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)cacheInfo);
        tx.saveAsset(asset);
    }

    @Nonnull
    protected CacheController getCacheController(@Nonnull Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        return this.cacheControllerHolder.require(assetKind.getCacheType());
    }

    public void invalidateProxyCaches() {
        super.invalidateProxyCaches();
        ((PyPiQuarantinedVersionFacet)this.facet(PyPiQuarantinedVersionFacet.class)).clearCache();
    }
}

