/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.orient.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.pypi.AssetKind;
import com.sonatype.nexus.repository.pypi.PyPiPathUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiGroupUtils;
import com.sonatype.nexus.repository.pypi.orient.internal.OrientPyPiGroupFacet;
import java.util.LinkedHashMap;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.template.TemplateHelper;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Named
@Singleton
class OrientPyPiIndexGroupHandler
extends GroupHandler {
    private final TemplateHelper templateHelper;

    @Inject
    public OrientPyPiIndexGroupHandler(TemplateHelper templateHelper) {
        this.templateHelper = (TemplateHelper)Preconditions.checkNotNull((Object)templateHelper);
    }

    protected Response doGet(@Nonnull Context context, @Nonnull GroupHandler.DispatchedRepositories dispatched) throws Exception {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)dispatched);
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().get(AssetKind.class));
        String name = AssetKind.ROOT_INDEX.equals((Object)assetKind) ? "simple/" : PyPiPathUtils.name((TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class));
        OrientPyPiGroupFacet groupFacet = (OrientPyPiGroupFacet)context.getRepository().facet(OrientPyPiGroupFacet.class);
        Content content = groupFacet.getFromCache(name, assetKind);
        LinkedHashMap memberResponses = this.getAll(context, groupFacet.members(), dispatched);
        if (groupFacet.isStale(name, content, memberResponses)) {
            Content index = groupFacet.buildIndexRoot(name, assetKind, PyPiGroupUtils.lazyMergeResult(name, assetKind, memberResponses, this.templateHelper));
            return index != null ? HttpResponses.ok((Payload)index) : HttpResponses.notFound();
        }
        return HttpResponses.ok((Payload)content);
    }
}

