/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.orient.internal;

import com.sonatype.nexus.repository.pypi.PyPiPathUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiIndexFacet;
import com.sonatype.nexus.repository.pypi.orient.internal.OrientPyPiDataUtils;
import javax.annotation.Priority;
import javax.inject.Named;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Priority(value=0x7FFFFFFF)
public class OrientPyPiIndexFacetImpl
extends FacetSupport
implements PyPiIndexFacet {
    @Override
    @TransactionalDeleteBlob
    public void deleteIndex(String packageName) {
        String indexPath;
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset cachedIndex = OrientPyPiDataUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), indexPath = PyPiPathUtils.indexPath(PyPiPathUtils.normalizeName(packageName)));
        if (cachedIndex == null) {
            indexPath = PyPiPathUtils.indexPath(packageName);
            cachedIndex = OrientPyPiDataUtils.findAsset(tx, bucket, indexPath);
        }
        if (cachedIndex != null) {
            tx.deleteAsset(cachedIndex);
        }
    }

    @Override
    @TransactionalDeleteBlob
    public void deleteRootIndex() {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset rootIndex = OrientPyPiDataUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), "simple/");
        if (rootIndex != null) {
            tx.deleteAsset(rootIndex);
        }
    }
}

