/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.orient.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.sonatype.nexus.repository.pypi.AssetKind;
import com.sonatype.nexus.repository.pypi.internal.PyPiStorageUtils;
import com.sonatype.nexus.repository.pypi.orient.internal.OrientPyPiDataUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.io.Cooperation;
import org.sonatype.nexus.common.io.CooperationFactory;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.cache.RepositoryCacheInvalidationService;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.group.GroupFacetImpl;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.AssetCreatedEvent;
import org.sonatype.nexus.repository.storage.AssetDeletedEvent;
import org.sonatype.nexus.repository.storage.AssetEvent;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
@Facet.Exposed
public class OrientPyPiGroupFacet
extends GroupFacetImpl {
    @Nullable
    private CooperationFactory.Builder cooperationBuilder;
    @Nullable
    private Cooperation indexRootCooperation;

    @Inject
    public OrientPyPiGroupFacet(RepositoryManager repositoryManager, ConstraintViolationFactory constraintViolationFactory, @Named(value="group") @Named(value="group") Type groupType, RepositoryCacheInvalidationService repositoryCacheInvalidationService) {
        super(repositoryManager, constraintViolationFactory, groupType, repositoryCacheInvalidationService);
    }

    @Inject
    protected void configureCooperation(CooperationFactory cooperationFactory, @Named(value="${nexus.pypi.indexRoot.cooperation.enabled:-true}") @Named(value="${nexus.pypi.indexRoot.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.pypi.indexRoot.cooperation.majorTimeout:-0s}") @Named(value="${nexus.pypi.indexRoot.cooperation.majorTimeout:-0s}") Time majorTimeout, @Named(value="${nexus.pypi.indexRoot.cooperation.minorTimeout:-30s}") @Named(value="${nexus.pypi.indexRoot.cooperation.minorTimeout:-30s}") Time minorTimeout, @Named(value="${nexus.pypi.indexRoot.cooperation.threadsPerKey:-100}") @Named(value="${nexus.pypi.indexRoot.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        if (cooperationEnabled) {
            this.cooperationBuilder = cooperationFactory.configure().majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey);
        }
    }

    @VisibleForTesting
    void buildCooperation() {
        if (Objects.nonNull(this.cooperationBuilder)) {
            this.indexRootCooperation = this.cooperationBuilder.build(String.valueOf(this.getRepository().getName()) + ":indexRoot");
        }
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.buildCooperation();
    }

    public Content buildIndexRoot(String name, AssetKind assetKind, Supplier<String> lazyMergeResult) throws IOException {
        if (Objects.isNull(this.indexRootCooperation)) {
            return this.buildMergedIndexRoot(name, lazyMergeResult, true);
        }
        try {
            return (Content)this.indexRootCooperation.cooperate(name, failover -> {
                Content latestContent;
                if (failover && Objects.nonNull(latestContent = (Content)this.indexRootCooperation.join(() -> this.getFromCache(name, assetKind)))) {
                    return latestContent;
                }
                return this.buildMergedIndexRoot(name, lazyMergeResult, true);
            });
        }
        catch (IOException e) {
            this.log.error("Unable to use Cooperation to merge {} for repository {}", new Object[]{name, this.getRepository().getName(), e});
            return this.buildMergedIndexRoot(name, lazyMergeResult, false);
        }
    }

    protected Content buildMergedIndexRoot(String name, Supplier<String> lazyMergeResult, boolean save) throws IOException {
        String html;
        block3: {
            try {
                html = lazyMergeResult.get();
                if (html != null) break block3;
                return null;
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        }
        Content newContent = new Content((Payload)new StringPayload(html, "text/html"));
        this.maintainCacheInfo(newContent.getAttributes());
        return save ? this.saveToCache(name, newContent) : newContent;
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetCreatedEvent event) {
        this.maybeInvalidateCache((AssetEvent)event);
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetDeletedEvent event) {
        this.maybeInvalidateCache((AssetEvent)event);
    }

    private void maybeInvalidateCache(AssetEvent event) {
        String assetKind = Objects.toString(event.getAsset().formatAttributes().get("asset_kind"));
        if (event.isLocal() && this.member(event.getRepositoryName()) && (AssetKind.ROOT_INDEX.name().equals(assetKind) || AssetKind.INDEX.name().equals(assetKind))) {
            this.invalidateCache("simple/");
        }
    }

    private void invalidateCache(String name) {
        UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
        try {
            this.doInvalidateCache(name);
        }
        finally {
            UnitOfWork.end();
        }
    }

    @Transactional(retryOn={ONeedRetryException.class}, swallow={ORecordNotFoundException.class})
    protected void doInvalidateCache(String name) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAssetWithProperty("name", (Object)name, tx.findBucket(this.getRepository()));
        if (asset != null && CacheInfo.invalidateAsset((Asset)asset)) {
            this.log.info("Invalidating cached content {} from {}", (Object)name, (Object)this.getRepository().getName());
            tx.saveAsset(asset);
        }
    }

    @TransactionalTouchBlob
    public Content getFromCache(String name, AssetKind assetKind) {
        Preconditions.checkArgument((AssetKind.INDEX.equals((Object)assetKind) || AssetKind.ROOT_INDEX.equals((Object)assetKind) ? 1 : 0) != 0, (Object)"Only index files are cached");
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = OrientPyPiDataUtils.findAsset(tx, bucket, name);
        if (asset == null) {
            return null;
        }
        return OrientPyPiDataUtils.toContent(asset, tx.requireBlob(asset.blobRef()));
    }

    public boolean isStale(String name, Content content, Map<Repository, Response> responses) {
        DateTime cacheModified = this.extractLastModified(content);
        if (cacheModified == null || this.isStale(content)) {
            return true;
        }
        for (Map.Entry<Repository, Response> response : responses.entrySet()) {
            DateTime memberLastModified;
            Content responseContent;
            Response responseValue = response.getValue();
            if (responseValue.getStatus().getCode() != 200 || (responseContent = (Content)responseValue.getPayload()) == null || (memberLastModified = (DateTime)responseContent.getAttributes().get("last_modified", DateTime.class)) != null && !memberLastModified.isAfter((ReadableInstant)cacheModified)) continue;
            this.log.debug("Found stale content while fetching {} from repository {}", (Object)name, (Object)response.getKey().getName());
            return true;
        }
        return false;
    }

    @TransactionalStoreBlob
    public Content saveToCache(String name, Content content) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.getAsset(tx, name);
        AttributesMap contentAttributes = Content.maintainLastModified((Asset)asset, null);
        contentAttributes.set(CacheInfo.class, (Object)this.cacheController.current());
        Content.applyToAsset((Asset)asset, (AttributesMap)contentAttributes);
        AssetBlob blob = this.updateAsset(tx, asset, content);
        Content response = new Content((Payload)new BlobPayload(blob.getBlob(), "text/html"));
        Content.extractFromAsset((Asset)asset, PyPiStorageUtils.HASH_ALGORITHMS, (AttributesMap)response.getAttributes());
        return response;
    }

    private DateTime extractLastModified(Content content) {
        DateTime lastModified = content != null && content.getAttributes().contains("last_modified") ? (DateTime)content.getAttributes().get("last_modified", DateTime.class) : null;
        return lastModified;
    }

    @TransactionalStoreBlob
    protected AssetBlob updateAsset(StorageTx tx, Asset asset, Content content) throws IOException {
        AttributesMap contentAttributes = Content.maintainLastModified((Asset)asset, (AttributesMap)content.getAttributes());
        Content.applyToAsset((Asset)asset, (AttributesMap)contentAttributes);
        InputStream inputStream = content.openInputStream();
        AssetBlob blob = tx.setBlob(asset, asset.name(), () -> inputStream, PyPiStorageUtils.HASH_ALGORITHMS, null, "text/html", true);
        tx.saveAsset(asset);
        return blob;
    }

    @TransactionalTouchBlob
    protected Asset getAsset(StorageTx tx, String name) {
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset assets = OrientPyPiDataUtils.findAsset(tx, bucket, name);
        if (assets == null) {
            assets = (Asset)tx.createAsset(bucket, this.getRepository().getFormat()).name(name);
            assets.formatAttributes().set("asset_kind", (Object)AssetKind.INDEX);
        }
        return assets;
    }
}

