/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.internal.search.sql;

import com.sonatype.nexus.repository.pypi.PyPiPathUtils;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.search.sql.SearchCustomFieldContributor;
import org.sonatype.nexus.repository.search.sql.SearchRecord;

@Named(value="pypi")
@Singleton
public class PyPiSearchCustomFieldContributor
extends ComponentSupport
implements SearchCustomFieldContributor {
    public void populateSearchCustomFields(SearchRecord searchTableData, Asset asset) {
        this.log.debug("Augmenting asset {}", (Object)asset.path());
        NestedAttributesMap formatAttributes = asset.attributes().child("pypi");
        searchTableData.addFormatFieldValue1((String)formatAttributes.get("classifiers", String.class));
        searchTableData.addFormatFieldValue2((String)formatAttributes.get("description", String.class));
        searchTableData.addFormatFieldValue3((String)formatAttributes.get("keywords", String.class));
        searchTableData.addFormatFieldValue4((String)formatAttributes.get("summary", String.class));
        String originalName = (String)formatAttributes.get("name", String.class);
        if (StringUtils.isNotBlank((CharSequence)originalName)) {
            searchTableData.addAliasComponentName(PyPiPathUtils.normalizeName(originalName, "."));
            searchTableData.addAliasComponentName(PyPiPathUtils.normalizeName(originalName, "-"));
            searchTableData.addAliasComponentName(PyPiPathUtils.normalizeName(originalName, "_"));
        }
    }
}

