/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import com.google.common.io.CharStreams;
import com.sonatype.nexus.repository.pypi.PyPiPathUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

public class PyPiStorageUtils {
    public static final List<HashAlgorithm> HASH_ALGORITHMS = ImmutableList.of((Object)HashAlgorithm.SHA1, (Object)HashAlgorithm.SHA256, (Object)HashAlgorithm.MD5);
    private static final String MD5_ATTRIBUTE_NAME = "md5_digest";

    public static void validateMd5Hash(Map<String, String> attributes, TempBlob tempBlob) {
        HashCode hashCode;
        String hashValue;
        String expectedDigest;
        if (attributes.containsKey(MD5_ATTRIBUTE_NAME) && !(expectedDigest = attributes.get(MD5_ATTRIBUTE_NAME)).equalsIgnoreCase(hashValue = (hashCode = (HashCode)tempBlob.getHashes().get(HashAlgorithm.MD5)).toString())) {
            throw new IllegalOperationException("Digests do not match, found: " + hashValue + ", expected: " + expectedDigest);
        }
    }

    public static void addAttribute(Map<String, String> attributes, PartPayload payload) throws IOException {
        Preconditions.checkNotNull(attributes);
        Preconditions.checkNotNull((Object)payload);
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(payload.openInputStream(), StandardCharsets.UTF_8));){
            String fieldName = payload.getFieldName();
            String newValue = CharStreams.toString((Readable)reader);
            String oldValue = attributes.get(payload.getFieldName());
            if (StringUtils.isNotBlank((String)oldValue)) {
                newValue = String.valueOf(oldValue) + "\n" + newValue;
            }
            attributes.put(fieldName, newValue);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void mayAddEtag(AttributesMap attributesMap, String hashCode) {
        if (attributesMap.contains("etag")) {
            return;
        }
        if (hashCode != null) {
            attributesMap.set("etag", (Object)("{SHA1{" + hashCode + "}}"));
        }
    }

    public static Map<String, String> getNameAttributes(String name) {
        HashMap<String, String> nameAttributes = new HashMap<String, String>();
        nameAttributes.put("name", name);
        nameAttributes.put("name_dash", PyPiPathUtils.normalizeName(name, "-"));
        nameAttributes.put("name_dot", PyPiPathUtils.normalizeName(name, "."));
        nameAttributes.put("name_underscore", PyPiPathUtils.normalizeName(name, "_"));
        return nameAttributes;
    }
}

