/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import com.sonatype.nexus.repository.pypi.PyPiPathUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiFileUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiLink;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.sonatype.nexus.common.template.EscapeHelper;
import org.sonatype.nexus.common.template.TemplateHelper;
import org.sonatype.nexus.common.template.TemplateParameters;

public final class PyPiIndexUtils {
    private static final String PYPI_REQUIRES_PYTHON = "data-requires-python";
    private static final String PYPI_DATA_YANKED = "data-yanked";
    public static final String ABSOLUTE_URL_PREFIX = "^https?://.*";
    public static final Pattern PATH_WITH_HOST_PREFIX = Pattern.compile("^/(?<host>[a-zA-Z0-9.-]+?)(?:/(?<port>\\d+))?/(?<scheme>https??)(?<path>/.*)");
    public static final String RELATIVE_PREFIX = "../../";
    private static final EscapeHelper escapeHelper = new EscapeHelper();

    public static List<PyPiLink> extractLinksFromIndex(InputStream in) throws IOException {
        Preconditions.checkNotNull((Object)in);
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            return PyPiIndexUtils.extractLinksFromIndex(CharStreams.toString((Readable)reader));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static List<PyPiLink> extractLinksFromIndex(String html) {
        Preconditions.checkNotNull((Object)html);
        ArrayList<PyPiLink> results = new ArrayList<PyPiLink>();
        Document document = Jsoup.parse((String)html);
        Elements links = document.select("a[href]");
        for (Element link : links) {
            String file = link.text().trim();
            String path = link.attr("href");
            String requiresPython = link.attr(PYPI_REQUIRES_PYTHON);
            String dataYanked = link.attr(PYPI_DATA_YANKED);
            results.add(new PyPiLink(file, path, requiresPython, dataYanked));
        }
        return results;
    }

    public static String buildIndexPage(TemplateHelper helper, String name, Collection<PyPiLink> links) {
        Preconditions.checkNotNull((Object)helper);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(links);
        URL template = PyPiIndexUtils.class.getResource("pypi-index.vm");
        TemplateParameters params = helper.parameters();
        params.set("name", (Object)name);
        params.set("assets", links.stream().map(PyPiIndexUtils::indexLinkToMap).collect(Collectors.toList()));
        return helper.render(template, params);
    }

    public static String buildRootIndexPage(TemplateHelper helper, Collection<PyPiLink> links) {
        Preconditions.checkNotNull((Object)helper);
        Preconditions.checkNotNull(links);
        URL template = PyPiIndexUtils.class.getResource("pypi-root-index.vm");
        TemplateParameters params = helper.parameters();
        params.set("assets", links.stream().map(PyPiIndexUtils::rootIndexLinkToMap).collect(Collectors.toList()));
        return helper.render(template, params);
    }

    static String buildOptionalAttribute(String attributeName, String attributeValue) {
        if (attributeValue != null && !attributeValue.isEmpty()) {
            return String.format("%s=\"%s\"", attributeName, escapeHelper.html(attributeValue));
        }
        return "";
    }

    static ImmutableMap<String, String> indexLinkToMap(PyPiLink link) {
        return ImmutableMap.of((Object)"link", (Object)link.getLink(), (Object)"file", (Object)link.getFile(), (Object)PYPI_REQUIRES_PYTHON, (Object)PyPiIndexUtils.buildOptionalAttribute(PYPI_REQUIRES_PYTHON, link.getDataRequiresPython()), (Object)PYPI_DATA_YANKED, (Object)PyPiIndexUtils.buildOptionalAttribute(PYPI_DATA_YANKED, link.getdataYanked()));
    }

    static ImmutableMap<String, String> rootIndexLinkToMap(PyPiLink link) {
        return ImmutableMap.of((Object)"link", (Object)link.getLink(), (Object)"name", (Object)link.getFile());
    }

    private static List<PyPiLink> makeLinksRelative(List<PyPiLink> oldLinks, Function<PyPiLink, String> linkTranslator) {
        Preconditions.checkNotNull(oldLinks);
        ArrayList<PyPiLink> newLinks = new ArrayList<PyPiLink>();
        for (PyPiLink oldLink : oldLinks) {
            String newLink = linkTranslator.apply(oldLink);
            if (newLink == null) continue;
            newLinks.add(new PyPiLink(oldLink.getFile(), newLink, oldLink.getDataRequiresPython(), oldLink.getdataYanked()));
        }
        return newLinks;
    }

    public static boolean validateIndexLinks(String packageName, List<PyPiLink> links) {
        Function<String, String> normalize = name -> name.replaceAll("[-_.]+", "-").toLowerCase(Locale.ENGLISH);
        String normalizedPackageName = normalize.apply(packageName);
        return links.stream().map(PyPiLink::getFile).filter(Objects::nonNull).map(normalize).anyMatch(file -> file.startsWith(normalizedPackageName));
    }

    public static List<PyPiLink> makeIndexLinksNexusPaths(String name, InputStream in) throws IOException {
        return PyPiIndexUtils.makePackageLinksNexusPaths(name, PyPiIndexUtils.extractLinksFromIndex(in));
    }

    static List<PyPiLink> makePackageLinksNexusPaths(String name, List<PyPiLink> oldLinks) {
        return PyPiIndexUtils.makeLinksRelative(oldLinks, link -> {
            String filename = link.getFile();
            String version = PyPiFileUtils.extractVersionFromFilename(filename);
            String result = RELATIVE_PREFIX + PyPiPathUtils.packagesPath(name, version, filename);
            int hashIndex = link.getLink().indexOf(35);
            if (hashIndex != -1) {
                result = String.valueOf(result) + link.getLink().substring(hashIndex);
            }
            return result;
        });
    }

    public static List<PyPiLink> makeRootIndexRelative(InputStream in) throws IOException {
        return PyPiIndexUtils.makeRootIndexLinksRelative(PyPiIndexUtils.extractLinksFromIndex(in));
    }

    static List<PyPiLink> makeRootIndexLinksRelative(List<PyPiLink> oldLinks) {
        return PyPiIndexUtils.makeLinksRelative(oldLinks, PyPiIndexUtils::maybeRewriteRootLink);
    }

    private static String maybeRewriteRootLink(PyPiLink pypiLink) {
        String link = pypiLink.getLink();
        if (link.contains("/simple/")) {
            String[] split = link.split("/simple/");
            return split[1];
        }
        return link;
    }

    private PyPiIndexUtils() {
    }
}

