/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.sonatype.nexus.repository.pypi.AssetKind;
import com.sonatype.nexus.repository.pypi.internal.PyPiIndexUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiLink;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.sonatype.nexus.common.template.TemplateHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;

public class PyPiGroupUtils {
    private PyPiGroupUtils() {
    }

    public static Supplier<String> lazyMergeResult(String name, AssetKind assetKind, Map<Repository, Response> remoteResponses, TemplateHelper templateHelper) {
        return Suppliers.memoize(() -> PyPiGroupUtils.mergeResponses(name, assetKind, remoteResponses, templateHelper));
    }

    private static String mergeResponses(String name, AssetKind assetKind, Map<Repository, Response> remoteResponses, TemplateHelper templateHelper) {
        HashSet<Response> successfulResponses = new HashSet<Response>();
        TreeMap results = new TreeMap();
        for (Map.Entry<Repository, Response> entry : remoteResponses.entrySet()) {
            Response response = entry.getValue();
            if (response.getStatus().getCode() != 200 || response.getPayload() == null) continue;
            successfulResponses.add(response);
        }
        if (successfulResponses.isEmpty()) {
            return null;
        }
        successfulResponses.forEach(successfulResponse -> PyPiGroupUtils.processResults(successfulResponse, results));
        if (AssetKind.INDEX == assetKind) {
            return PyPiIndexUtils.buildIndexPage(templateHelper, name, results.values());
        }
        return PyPiIndexUtils.buildRootIndexPage(templateHelper, results.values());
    }

    private static void processResults(Response response, Map<String, PyPiLink> results) {
        Preconditions.checkNotNull((Object)response);
        Preconditions.checkNotNull(results);
        Payload payload = (Payload)Preconditions.checkNotNull((Object)response.getPayload());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream in = payload.openInputStream();){
                PyPiIndexUtils.extractLinksFromIndex(in).forEach(link -> {
                    PyPiLink pyPiLink = results.putIfAbsent(link.getFile().toLowerCase(), (PyPiLink)link);
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

