/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.repository.pypi.internal.PyPiArchiveType;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PyPiFileUtils {
    static final Pattern VERSION_NUMBER_PATTERN = Pattern.compile("\\-\\d");
    static final Map<String, PyPiArchiveType> SUPPORTED_EXTENSIONS = new ImmutableMap.Builder().put((Object)".tar.bz2", (Object)PyPiArchiveType.TAR_BZ2).put((Object)".tbz", (Object)PyPiArchiveType.TAR_BZ2).put((Object)".tar.gz", (Object)PyPiArchiveType.TAR_GZ).put((Object)".tgz", (Object)PyPiArchiveType.TAR_GZ).put((Object)".tlz", (Object)PyPiArchiveType.TAR_LZ).put((Object)".tar.lz", (Object)PyPiArchiveType.TAR_LZ).put((Object)".tar.lzma", (Object)PyPiArchiveType.TAR_LZ).put((Object)".tar.xz", (Object)PyPiArchiveType.TAR_XZ).put((Object)".txz", (Object)PyPiArchiveType.TAR_XZ).put((Object)".tar.z", (Object)PyPiArchiveType.TAR_Z).put((Object)".tz", (Object)PyPiArchiveType.TAR_Z).put((Object)".taz", (Object)PyPiArchiveType.TAR_Z).put((Object)".tar", (Object)PyPiArchiveType.TAR).put((Object)".zip", (Object)PyPiArchiveType.ZIP).put((Object)".whl", (Object)PyPiArchiveType.ZIP).put((Object)".egg", (Object)PyPiArchiveType.ZIP).build();

    public static String extractNameFromPath(String path) {
        Preconditions.checkNotNull((Object)path);
        String[] parts = path.split("/");
        return parts[1];
    }

    public static String extractVersionFromPath(String path) {
        Preconditions.checkNotNull((Object)path);
        String[] parts = path.split("/");
        return parts[2];
    }

    public static String extractFilenameFromPath(String path) {
        Preconditions.checkNotNull((Object)path);
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static String extractNameFromFilename(String filename) {
        Preconditions.checkNotNull((Object)filename);
        return filename.substring(0, PyPiFileUtils.getFilenameVersionStart(filename));
    }

    public static String extractVersionFromFilename(String filename) {
        int end;
        int begin;
        Preconditions.checkNotNull((Object)filename);
        String base = PyPiFileUtils.removeExtension(filename);
        if (filename.endsWith(".whl")) {
            begin = base.indexOf(45) + 1;
            end = base.indexOf(45, begin);
        } else {
            begin = PyPiFileUtils.getFilenameVersionStart(filename) + 1;
            end = base.indexOf(45, begin);
            if (end == -1) {
                end = base.length();
            }
        }
        return base.substring(begin, end);
    }

    private static int getFilenameVersionStart(String filename) {
        Matcher matcher = VERSION_NUMBER_PATTERN.matcher(filename);
        if (matcher.find()) {
            return matcher.start();
        }
        if (filename.contains("-")) {
            return filename.indexOf(45);
        }
        return 0;
    }

    static String removeExtension(String filename) {
        Preconditions.checkNotNull((Object)filename);
        String lowercaseFilename = filename.toLowerCase(Locale.ENGLISH);
        for (String extension : SUPPORTED_EXTENSIONS.keySet()) {
            if (!lowercaseFilename.endsWith(extension)) continue;
            return filename.substring(0, lowercaseFilename.lastIndexOf(extension));
        }
        if (filename.contains(".")) {
            return filename.substring(0, filename.lastIndexOf(46));
        }
        return filename;
    }

    static String extractExtension(String filename) {
        Preconditions.checkNotNull((Object)filename);
        String lowercaseFilename = filename.toLowerCase(Locale.ENGLISH);
        for (String extension : SUPPORTED_EXTENSIONS.keySet()) {
            if (!lowercaseFilename.endsWith(extension)) continue;
            return extension;
        }
        if (filename.contains(".")) {
            return lowercaseFilename.substring(lowercaseFilename.lastIndexOf(46));
        }
        return "";
    }

    private PyPiFileUtils() {
    }
}

