/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.internal;

import com.sonatype.nexus.repository.pypi.AssetKind;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;

public abstract class PyPiExportAssetFilterSupport
extends ComponentSupport {
    public boolean shouldSkipAsset(String path, String kind) {
        try {
            AssetKind assetKind = AssetKind.valueOf(kind);
            switch (assetKind) {
                case ROOT_INDEX: 
                case INDEX: 
                case SEARCH: {
                    this.log.trace("PyPI asset {} is NOT allowed for processing, will skip.", (Object)path);
                    return true;
                }
            }
        }
        catch (Exception e) {
            this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "PyPI asset {} has invalid assetkind '{}'. Will skip for export. {}", new Object[]{path, kind, this.log.isDebugEnabled() ? e : ""});
            return true;
        }
        this.log.trace("PyPI asset {} is allowed for processing.", (Object)path);
        return false;
    }
}

