/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.datastore.upgrade;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.UpgradeTaskScheduler;
import org.sonatype.nexus.upgrade.datastore.RepeatableDatabaseMigrationStep;

@Named
@Singleton
public class PypiGenerateMissingSha256ChecksumsMigrationStep
extends RepeatableDatabaseMigrationStep {
    private final TaskScheduler taskScheduler;
    private final UpgradeTaskScheduler upgradeTaskScheduler;

    @Inject
    public PypiGenerateMissingSha256ChecksumsMigrationStep(TaskScheduler ts, UpgradeTaskScheduler uts) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)ts);
        this.upgradeTaskScheduler = (UpgradeTaskScheduler)Preconditions.checkNotNull((Object)uts);
    }

    public Integer getChecksum() {
        return 1;
    }

    public void migrate(Connection connection) throws Exception {
        this.log.info("Scheduling post-startup tasks to generate missing PyPI SHA256 checksums");
        List<String> pypiRepositories = this.getHostedAndProxyPypiRepositories(connection);
        this.log.debug("PyPI proxy and hosted repositories found: {}", pypiRepositories);
        for (String repositoryName : pypiRepositories) {
            this.scheduleSha256ChecksumsRebuild(repositoryName);
        }
    }

    private void scheduleSha256ChecksumsRebuild(String repositoryName) {
        TaskConfiguration taskConfiguration = this.taskScheduler.createTaskConfigurationInstance("repository.pypi.generate-missing-sha256-checksums");
        taskConfiguration.setString("repositoryName", repositoryName);
        this.upgradeTaskScheduler.schedule(taskConfiguration);
        this.log.debug("Post-startup task to generate missing PyPI SHA256 checksums has been scheduled for: {}", (Object)repositoryName);
    }

    private List<String> getHostedAndProxyPypiRepositories(Connection connection) throws SQLException {
        LinkedList repositories = Lists.newLinkedList();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Statement s = connection.createStatement();){
            ResultSet rs = s.executeQuery("SELECT name FROM repository WHERE recipe_name in ('pypi-hosted', 'pypi-proxy')");
            while (rs.next()) {
                repositories.add(rs.getString(1));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return repositories;
    }
}

